/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.container;

import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.ClassBlockMatcher;
import org.xwiki.rendering.macro.container.LayoutManager;
import org.xwiki.skinx.SkinExtension;
import org.xwiki.xml.XMLAttributeValue;

@Component
@Named(value="columns")
@Singleton
public class ColumnsLayoutManager
implements LayoutManager {
    private static final String CLASS_ATTRIBUTE_NAME = "class";
    private static final String COLUMN_CLASS_VALUE = "column";
    private static final String FIRST_COLUMN_CLASS_VALUE = "first-column";
    private static final String LAST_COLUMN_CLASS_VALUE = "last-column";
    @Inject
    @Named(value="ssfx")
    private SkinExtension ssfx;

    @Override
    public void layoutContainer(Block container) {
        List innerGroups = container.getBlocks((BlockMatcher)new ClassBlockMatcher(GroupBlock.class), Block.Axes.CHILD);
        int count = innerGroups.size();
        if (count == 0) {
            return;
        }
        HashMap<String, Boolean> skinxParams = new HashMap<String, Boolean>();
        skinxParams.put("forceSkinAction", true);
        this.ssfx.use("uicomponents/container/columns.css", skinxParams);
        for (int i = 0; i < count; ++i) {
            GroupBlock column = (GroupBlock)innerGroups.get(i);
            XMLAttributeValue classValue = new XMLAttributeValue(column.getParameter(CLASS_ATTRIBUTE_NAME));
            classValue.addValue(COLUMN_CLASS_VALUE);
            if (i == 0) {
                classValue.addValue(FIRST_COLUMN_CLASS_VALUE);
            }
            if (i == count - 1) {
                classValue.addValue(LAST_COLUMN_CLASS_VALUE);
            }
            column.setParameter(CLASS_ATTRIBUTE_NAME, classValue.toString());
        }
        XMLAttributeValue classValue = new XMLAttributeValue(container.getParameter(CLASS_ATTRIBUTE_NAME));
        classValue.addValues(new String[]{"container-columns", "container-columns-" + count});
        container.setParameter(CLASS_ATTRIBUTE_NAME, classValue.toString());
        HashMap<String, String> clearFloatsParams = new HashMap<String, String>();
        clearFloatsParams.put(CLASS_ATTRIBUTE_NAME, "clearfloats");
        container.addChild((Block)new GroupBlock(clearFloatsParams));
    }

    @Override
    public Object getParameter(String parameterName) {
        return null;
    }

    @Override
    public void setParameter(String parameterName, Object parameterValue) {
    }
}

