/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.code.source;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.EmailClass;
import com.xpn.xwiki.objects.classes.PasswordClass;
import com.xpn.xwiki.objects.classes.TextAreaClass;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.mail.GeneralMailConfiguration;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.internal.macro.code.source.EntityCodeMacroSourceLoader;
import org.xwiki.rendering.internal.parser.pygments.PygmentsUtils;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.code.source.CodeMacroSource;
import org.xwiki.rendering.macro.source.MacroContentSourceReference;
import org.xwiki.rendering.syntax.Syntax;

@Component(hints={"OBJECT_PROPERTY", "PAGE_OBJECT_PROPERTY"})
@Singleton
public class DocumentObjectPropertyCodeMacroSourceLoader
implements EntityCodeMacroSourceLoader {
    @Inject
    private GeneralMailConfiguration mailConfiguration;

    @Override
    public CodeMacroSource load(XWikiDocument document, EntityReference entityReference, MacroContentSourceReference reference, XWikiContext xcontext) throws MacroExecutionException {
        BaseProperty xobjectProperty;
        BaseObject xobject = document.getXObject(entityReference.getParent());
        try {
            xobjectProperty = (BaseProperty)xobject.get(entityReference.getName());
        }
        catch (XWikiException e) {
            throw new MacroExecutionException("Failed to access object property [" + String.valueOf(entityReference) + "]", (Throwable)e);
        }
        if (xobjectProperty == null) {
            throw new MacroExecutionException("Unknown property [" + String.valueOf(entityReference) + "]");
        }
        return new CodeMacroSource(reference, xobjectProperty.toText(), this.getLanguage(xobject, document, entityReference, xcontext));
    }

    private String getLanguage(BaseObject xobject, XWikiDocument document, EntityReference entityReference, XWikiContext xcontext) throws MacroExecutionException {
        BaseClass xclass = xobject.getXClass(xcontext);
        if (xclass != null) {
            PropertyInterface xclassProperty = xclass.get(entityReference.getName());
            if (xclassProperty instanceof PasswordClass) {
                throw new MacroExecutionException(String.format("Displaying content of property [%s] is not allowed because it's a passwordl", entityReference));
            }
            if (xclassProperty instanceof EmailClass && this.mailConfiguration.shouldObfuscate()) {
                throw new MacroExecutionException(String.format("Displaying content of property [%s] is not allowed because it's an obfuscated email", entityReference));
            }
            String language = null;
            if (xclassProperty instanceof TextAreaClass) {
                TextAreaClass textarea = (TextAreaClass)xclassProperty;
                TextAreaClass.ContentType contentType = TextAreaClass.ContentType.getByValue((String)textarea.getContentType());
                if (contentType == TextAreaClass.ContentType.VELOCITY_CODE || contentType == TextAreaClass.ContentType.VELOCITYWIKI) {
                    language = "velocity";
                } else if (contentType == TextAreaClass.ContentType.WIKI_TEXT) {
                    language = PygmentsUtils.syntaxToLanguage((Syntax)document.getSyntax());
                }
            }
            return language;
        }
        return null;
    }
}

