/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.code.source;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.code.source.CodeMacroSource;
import org.xwiki.rendering.macro.code.source.CodeMacroSourceFactory;
import org.xwiki.rendering.macro.source.MacroContentSourceReference;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Singleton
public class DefaultCodeMacroSourceFactory
implements CodeMacroSourceFactory {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;

    @Override
    public CodeMacroSource getContent(MacroContentSourceReference reference, MacroTransformationContext context) throws MacroExecutionException {
        ComponentManager componentManager;
        String type = reference.getType();
        if (type != null && !type.isEmpty() && !type.equals("default") && (componentManager = (ComponentManager)this.componentManagerProvider.get()).hasComponent(CodeMacroSourceFactory.class, type)) {
            CodeMacroSourceFactory factory;
            try {
                factory = (CodeMacroSourceFactory)componentManager.getInstance(CodeMacroSourceFactory.class, type);
            }
            catch (ComponentLookupException e) {
                throw new MacroExecutionException("Failed to lookup code macro source factory for [" + type + "]", (Throwable)e);
            }
            return factory.getContent(reference, context);
        }
        throw new MacroExecutionException("Unsupported source type [" + type + "]");
    }
}

