/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.code;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.properties.PropertyException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.internal.code.layout.CodeLayoutHandler;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.MacroPreparationException;
import org.xwiki.rendering.macro.box.AbstractBoxMacro;
import org.xwiki.rendering.macro.code.CodeMacroParameters;
import org.xwiki.rendering.macro.code.source.CodeMacroSource;
import org.xwiki.rendering.macro.code.source.CodeMacroSourceFactory;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.parser.HighlightParser;
import org.xwiki.rendering.parser.ParseException;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="code")
@Singleton
public class CodeMacro
extends AbstractBoxMacro<CodeMacroParameters> {
    static final String ATTRIBUTE_PREPARE_RESULT = "prepare.code.result";
    private static final String DESCRIPTION = "Highlights code snippets of various programming languages";
    private static final String LANGUAGE_NONE = "none";
    private static final String CONTENT_DESCRIPTION = "the content to highlight";
    @Inject
    @Named(value="plain/1.0")
    private Parser plainTextParser;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private CodeMacroSourceFactory sourceFactory;
    @Inject
    private Logger logger;

    public CodeMacro() {
        super("Code", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(CONTENT_DESCRIPTION, false), CodeMacroParameters.class);
        this.setDefaultCategories(Set.of("Formatting"));
    }

    protected boolean isContentChecked() {
        return false;
    }

    private CodeMacroSource getContent(CodeMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        if (parameters.getSource() != null) {
            return this.sourceFactory.getContent(parameters.getSource(), context);
        }
        return content != null ? new CodeMacroSource(null, content, null) : null;
    }

    protected List<Block> parseContent(CodeMacroParameters parameters, String inputContent, MacroTransformationContext context) throws MacroExecutionException {
        List<Block> result = this.getPreparedResult(context.getCurrentMacroBlock());
        if (result != null) {
            ArrayList<Block> clonedResult = new ArrayList<Block>(result.size());
            for (Block block : result) {
                clonedResult.add(block.clone());
            }
            return clonedResult;
        }
        return this.highlight(parameters, inputContent, context);
    }

    private List<Block> highlight(CodeMacroParameters parameters, String inputContent, MacroTransformationContext context) throws MacroExecutionException {
        List<Object> result;
        CodeMacroSource source = this.getContent(parameters, inputContent, context);
        if (source == null) {
            return null;
        }
        try {
            result = LANGUAGE_NONE.equalsIgnoreCase(parameters.getLanguage()) ? (StringUtils.isEmpty((CharSequence)source.getContent()) ? Collections.emptyList() : ((Block)this.plainTextParser.parse((Reader)new StringReader(source.getContent())).getChildren().get(0)).getChildren()) : this.highlight(parameters, source);
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to highlight content", (Throwable)e);
        }
        LinkedHashMap<String, String> formatParameters = new LinkedHashMap<String, String>();
        formatParameters.put("class", "code");
        if (context.isInline()) {
            result = Arrays.asList(new FormatBlock((List)result, Format.NONE, formatParameters));
        } else {
            try {
                CodeLayoutHandler layoutHandler = (CodeLayoutHandler)((ComponentManager)this.componentManagerProvider.get()).getInstance(CodeLayoutHandler.class, parameters.getLayout().getHint());
                result = layoutHandler.layout(result, source.getContent());
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to load code layout handler for layout type [{}], no layout will be applied", (Object)parameters.getLayout().name(), (Object)e);
            }
            result = Arrays.asList(new GroupBlock(result, formatParameters));
        }
        return result;
    }

    private List<Block> highlight(CodeMacroParameters parameters, CodeMacroSource source) throws ParseException, ComponentLookupException {
        String language = parameters.getLanguage();
        if (language == null) {
            language = source.getLanguage();
        }
        ComponentManager componentManager = (ComponentManager)this.componentManagerProvider.get();
        if (language != null && componentManager.hasComponent(HighlightParser.class, language)) {
            try {
                HighlightParser parser = (HighlightParser)componentManager.getInstance(HighlightParser.class, language);
                return parser.highlight(language, new StringReader(source.getContent()));
            }
            catch (ComponentLookupException e) {
                this.logger.error("Faild to load highlighting parser for language [{}]", (Object)language, (Object)e);
            }
        }
        this.logger.debug("Can't find any specific highlighting parser for language [{}]. Trying the default highlighting parser.", (Object)language);
        HighlightParser parser = (HighlightParser)componentManager.getInstance(HighlightParser.class, "default");
        return parser.highlight(language, new StringReader(source.getContent()));
    }

    public void prepare(MacroBlock macroBlock) throws MacroPreparationException {
        if (macroBlock.getParameter("source") == null) {
            List<Block> blocks;
            CodeMacroParameters macroParameters = new CodeMacroParameters();
            try {
                this.beanManager.populate((Object)macroParameters, macroBlock.getParameters());
            }
            catch (PropertyException e) {
                throw new MacroPreparationException("Failed to populate macro parameters", (Throwable)e);
            }
            MacroTransformationContext context = new MacroTransformationContext();
            context.setInline(macroBlock.isInline());
            try {
                blocks = this.highlight(macroParameters, macroBlock.getContent(), context);
            }
            catch (MacroExecutionException e) {
                throw new MacroPreparationException("Failed to prepare content", (Throwable)e);
            }
            macroBlock.setAttribute(ATTRIBUTE_PREPARE_RESULT, blocks);
        }
    }

    private List<Block> getPreparedResult(MacroBlock macroBlock) {
        return (List)macroBlock.getAttribute(ATTRIBUTE_PREPARE_RESULT);
    }

    public boolean isExecutionIsolated(CodeMacroParameters parameters, String content) {
        return true;
    }
}

