/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.async.internal;

import java.util.List;
import javax.inject.Inject;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererConfiguration;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererExecutor;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.block.match.MetadataBlockMatcher;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroContentParser;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.transformation.MacroTransformationContext;
import org.xwiki.rendering.transformation.RenderingContext;

public abstract class AbstractExecutedContentMacro<P>
extends AbstractMacro<P> {
    @Inject
    protected BlockAsyncRendererExecutor executor;
    @Inject
    protected MacroContentParser parser;
    @Inject
    protected DocumentAccessBridge documentAccessBridge;
    @Inject
    protected DocumentReferenceResolver<String> resolver;
    @Inject
    protected RenderingContext renderingContext;

    protected AbstractExecutedContentMacro(String name, String description, ContentDescriptor contentDescriptor, Class<?> parametersBeanClass) {
        super(name, description, contentDescriptor, parametersBeanClass);
    }

    public boolean supportsInlineMode() {
        return true;
    }

    protected String getCurrentSource(MacroTransformationContext context) {
        String currentSource = null;
        if (context != null) {
            MetaDataBlock metaDataBlock;
            currentSource = context.getTransformationContext() != null ? context.getTransformationContext().getId() : null;
            MacroBlock currentMacroBlock = context.getCurrentMacroBlock();
            if (currentMacroBlock != null && (metaDataBlock = (MetaDataBlock)currentMacroBlock.getFirstBlock((BlockMatcher)new MetadataBlockMatcher("source"), Block.Axes.ANCESTOR_OR_SELF)) != null) {
                currentSource = (String)metaDataBlock.getMetaData().getMetaData("source");
            }
        }
        return currentSource;
    }

    protected BlockAsyncRendererConfiguration createBlockAsyncRendererConfiguration(List<?> idElements, Block content, MacroTransformationContext context) {
        return this.createBlockAsyncRendererConfiguration(idElements, content, this.getCurrentSource(context), context);
    }

    protected BlockAsyncRendererConfiguration createBlockAsyncRendererConfiguration(List<?> idElements, Block content, String source, MacroTransformationContext context) {
        BlockAsyncRendererConfiguration configuration = new BlockAsyncRendererConfiguration(idElements, content);
        if (source != null) {
            DocumentReference sourceReference = this.resolver.resolve((Object)source, new Object[0]);
            configuration.setSecureReference(sourceReference, this.documentAccessBridge.getCurrentAuthorReference());
            configuration.useEntity((EntityReference)sourceReference);
        }
        configuration.setInline(context.isInline());
        configuration.setDefaultSyntax(this.parser.getCurrentSyntax(context));
        configuration.setTargetSyntax(this.renderingContext.getTargetSyntax());
        configuration.setTransformationId(context.getTransformationContext().getId());
        configuration.setResricted(context.getTransformationContext().isRestricted());
        configuration.addContextEntries(new String[]{"rendering.restricted"});
        return configuration;
    }
}

