/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.async.internal.service;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.async.internal.service.AsyncRendererResourceReference;
import org.xwiki.resource.CreateResourceReferenceException;
import org.xwiki.resource.ResourceReference;
import org.xwiki.resource.ResourceType;
import org.xwiki.resource.UnsupportedResourceReferenceException;
import org.xwiki.url.ExtendedURL;
import org.xwiki.url.internal.AbstractResourceReferenceResolver;

@Component
@Named(value="asyncrenderer")
@Singleton
public class AsyncRendererResourceReferenceResolver
extends AbstractResourceReferenceResolver {
    public ResourceReference resolve(ExtendedURL representation, ResourceType resourceType, Map<String, Object> parameters) throws CreateResourceReferenceException, UnsupportedResourceReferenceException {
        List pathSegments = representation.getSegments();
        ArrayList<String> id = new ArrayList<String>(pathSegments.size());
        for (String pathSegment : representation.getSegments()) {
            try {
                id.add(URLDecoder.decode(pathSegment, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new CreateResourceReferenceException("Failed to decode the path segment", (Throwable)e);
            }
        }
        String clientId = this.getParameter(representation, "clientId");
        long timeout = Long.MAX_VALUE;
        String timeoutString = this.getParameter(representation, "timeout");
        if (timeoutString != null) {
            timeout = NumberUtils.toLong((String)timeoutString, (long)timeout);
        }
        String wiki = this.getParameter(representation, "wiki");
        return new AsyncRendererResourceReference(resourceType, id, clientId, timeout, wiki);
    }

    private String getParameter(ExtendedURL representation, String key) {
        List timeouts = (List)representation.getParameters().get(key);
        if (CollectionUtils.isNotEmpty((Collection)timeouts)) {
            return (String)timeouts.get(0);
        }
        return null;
    }
}

