/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.async.internal.block;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentRole;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.RenderingException;
import org.xwiki.rendering.async.AsyncContext;
import org.xwiki.rendering.async.internal.block.AbstractBlockAsyncRenderer;
import org.xwiki.rendering.async.internal.block.BlockAsyncRendererConfiguration;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.CompositeBlock;
import org.xwiki.rendering.block.MetaDataBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.rendering.transformation.TransformationContext;
import org.xwiki.rendering.util.ErrorBlockGenerator;
import org.xwiki.rendering.util.ParserUtils;

@Component(roles={DefaultBlockAsyncRenderer.class})
public class DefaultBlockAsyncRenderer
extends AbstractBlockAsyncRenderer {
    private static final String TM_FAILEDASYNC = "rendering.async.error.failed";
    private static final ParserUtils PARSERUTILS = new ParserUtils();
    @Inject
    private AsyncContext asyncContext;
    @Inject
    private ErrorBlockGenerator errorBlockGenerator;
    private BlockAsyncRendererConfiguration configuration;

    public void initialize(BlockAsyncRendererConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public List<String> getId() {
        return this.configuration.getId();
    }

    @Override
    public boolean isAsyncAllowed() {
        return this.configuration.isAsyncAllowed();
    }

    @Override
    public boolean isCacheAllowed() {
        return this.configuration.isCacheAllowed();
    }

    @Override
    public boolean isInline() {
        return this.configuration.isInline();
    }

    @Override
    public Syntax getTargetSyntax() {
        return this.configuration.getTargetSyntax();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Block execute(boolean async, boolean cached) throws RenderingException {
        CompositeBlock resultBlock;
        try {
            void var5_11;
            XDOM xDOM;
            for (EntityReference entityReference : this.configuration.getReferences()) {
                this.asyncContext.useEntity(entityReference);
            }
            for (ComponentRole componentRole : this.configuration.getRoles()) {
                this.asyncContext.useComponent(componentRole.getRoleType(), componentRole.getRoleHint());
            }
            Block block = this.configuration.getBlock();
            if (this.configuration.isInline()) {
                block = PARSERUTILS.convertToInline(block, true);
            }
            if ((xDOM = this.configuration.getXDOM()) == null) {
                Block rootBlock = block.getRoot();
                if (rootBlock instanceof XDOM) {
                    XDOM xDOM2 = (XDOM)rootBlock;
                } else {
                    XDOM xDOM3 = new XDOM(Collections.singletonList(rootBlock));
                }
            }
            resultBlock = this.tranform((XDOM)var5_11, block);
        }
        catch (Exception e) {
            resultBlock = new CompositeBlock(this.errorBlockGenerator.generateErrorBlocks(this.configuration.isInline(), TM_FAILEDASYNC, "Failed to execute asynchronous content", null, new Object[]{e}));
        }
        return resultBlock;
    }

    private Block tranform(XDOM xdom, Block block) throws RenderingException {
        TransformationContext transformationContext = new TransformationContext(xdom, this.configuration.getDefaultSyntax(), this.configuration.isResricted());
        transformationContext.setTargetSyntax(this.configuration.getTargetSyntax());
        transformationContext.setId(this.configuration.getTransformationId());
        this.transform(block, transformationContext);
        if (block instanceof XDOM) {
            return new MetaDataBlock(block.getChildren(), ((XDOM)block).getMetaData());
        }
        return block;
    }
}

