/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.async.internal;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentRole;
import org.xwiki.component.descriptor.DefaultComponentRole;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.model.internal.reference.EntityReferenceFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.async.AsyncContext;
import org.xwiki.security.authorization.Right;

@Component
@Singleton
public class DefaultAsyncContext
implements AsyncContext {
    private static final String KEY_ENABLED = "rendering.async.enabled";
    private static final String KEY_CONTEXTUSE = "rendering.async.contextuse";
    @Inject
    private Execution execution;
    @Inject
    private EntityReferenceFactory factory;

    @Override
    public boolean isEnabled() {
        ExecutionContext econtext = this.execution.getContext();
        if (econtext != null) {
            return econtext.getProperty(KEY_ENABLED) == Boolean.TRUE;
        }
        return false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        ExecutionContext context = this.execution.getContext();
        if (!context.hasProperty(KEY_ENABLED)) {
            context.newProperty(KEY_ENABLED).inherited().declare();
        }
        context.setProperty(KEY_ENABLED, (Object)enabled);
    }

    public void pushContextUse() {
        ExecutionContext econtext = this.execution.getContext();
        if (econtext != null) {
            LinkedList<ContextUse> deque = (LinkedList<ContextUse>)econtext.getProperty(KEY_CONTEXTUSE);
            if (deque == null) {
                deque = new LinkedList<ContextUse>();
                ExecutionContext.DeclarationBuilder propertyBuilder = econtext.newProperty(KEY_CONTEXTUSE);
                propertyBuilder.inherited();
                propertyBuilder.makeFinal();
                propertyBuilder.initial(deque);
                propertyBuilder.declare();
            }
            deque.push(new ContextUse());
        }
    }

    public ContextUse popContextUse() {
        Deque deque;
        ExecutionContext econtext = this.execution.getContext();
        if (econtext != null && (deque = (Deque)econtext.getProperty(KEY_CONTEXTUSE)) != null && !deque.isEmpty()) {
            return (ContextUse)deque.pop();
        }
        return null;
    }

    private ContextUse getContextUse() {
        Deque deque;
        ExecutionContext econtext = this.execution.getContext();
        if (econtext != null && (deque = (Deque)econtext.getProperty(KEY_CONTEXTUSE)) != null && !deque.isEmpty()) {
            return (ContextUse)deque.peek();
        }
        return null;
    }

    @Override
    public void useEntity(EntityReference reference) {
        ContextUse contextUse = this.getContextUse();
        if (contextUse != null) {
            contextUse.references.add(this.factory.getReference(reference));
        }
    }

    @Override
    public void useComponent(Type roleType) {
        ContextUse contextUse = this.getContextUse();
        if (contextUse != null) {
            contextUse.roleTypes.add(roleType);
        }
    }

    @Override
    public void useComponent(Type roleType, String roleHint) {
        ContextUse contextUse = this.getContextUse();
        if (contextUse != null) {
            contextUse.roles.add((ComponentRole<?>)new DefaultComponentRole(roleType, roleHint));
        }
    }

    @Override
    public void useRight(Right right, DocumentReference userReference, EntityReference entityReference, boolean allowed) {
        ContextUse contextUse = this.getContextUse();
        if (contextUse != null) {
            contextUse.rights.add(new RightEntry(right, userReference, entityReference, allowed));
        }
    }

    @Override
    public void use(String type, Object value) {
        ContextUse contextUse = this.getContextUse();
        if (contextUse != null) {
            Collection<Object> values = contextUse.uses.get(type);
            if (values == null) {
                values = new LinkedHashSet<Object>();
                contextUse.uses.put(type, values);
            }
            values.add(value);
        }
    }

    public static class ContextUse {
        private final Set<EntityReference> references = new HashSet<EntityReference>();
        private final Set<Type> roleTypes = new HashSet<Type>();
        private final Set<ComponentRole<?>> roles = new HashSet();
        private final Set<RightEntry> rights = new HashSet<RightEntry>();
        private final Map<String, Collection<Object>> uses = new HashMap<String, Collection<Object>>();

        public Set<EntityReference> getReferences() {
            return this.references;
        }

        public Set<Type> getRoleTypes() {
            return this.roleTypes;
        }

        public Set<ComponentRole<?>> getRoles() {
            return this.roles;
        }

        public Set<RightEntry> getRights() {
            return this.rights;
        }

        public Map<String, Collection<Object>> getUses() {
            return this.uses;
        }
    }

    public static class RightEntry {
        private final Right right;
        private final DocumentReference userReference;
        private final EntityReference entityReference;
        private final boolean allowed;

        public RightEntry(Right right, DocumentReference userReference, EntityReference entityReference, boolean result) {
            this.right = right;
            this.userReference = userReference;
            this.entityReference = entityReference;
            this.allowed = result;
        }

        public Right getRight() {
            return this.right;
        }

        public DocumentReference getUserReference() {
            return this.userReference;
        }

        public EntityReference getEntityReference() {
            return this.entityReference;
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof RightEntry) {
                EqualsBuilder builder = new EqualsBuilder();
                builder.append((Object)this.right, (Object)((RightEntry)obj).right);
                builder.append((Object)this.userReference, (Object)((RightEntry)obj).userReference);
                builder.append((Object)this.entityReference, (Object)((RightEntry)obj).entityReference);
                return builder.build();
            }
            return false;
        }

        public int hashCode() {
            HashCodeBuilder builder = new HashCodeBuilder();
            builder.append((Object)this.right);
            builder.append((Object)this.userReference);
            builder.append((Object)this.entityReference);
            return builder.build();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append('{');
            builder.append("right=").append(this.right);
            builder.append(", user=").append(this.userReference);
            builder.append(", entity=").append(this.entityReference);
            builder.append(", allowed=").append(this.allowed);
            builder.append('}');
            return builder.toString();
        }
    }
}

