/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.job;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.event.DocumentsDeletingEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.Job;
import org.xwiki.job.event.status.CancelableJobStatus;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.CancelableEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.refactoring.job.XClassBreakingQuestion;
import org.xwiki.refactoring.job.question.EntitySelection;

@Component
@Singleton
@Named(value="XClassDeletingListener")
public class XClassDeletingListener
extends AbstractEventListener {
    private static final String QUERY = "select distinct obj.name from BaseObject obj where obj.className=:className order by obj.name asc";
    @Inject
    private Logger logger;
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localSerializer;
    @Inject
    private EntityReferenceResolver<String> resolver;
    @Inject
    private DocumentAccessBridge documentAccessBridge;

    public XClassDeletingListener() {
        super("XClass Deleting Listener", new Event[]{new DocumentsDeletingEvent()});
    }

    private XClassBreakingQuestion buildQuestion(Job job, CancelableEvent event, Object data) {
        if (event.isCanceled()) {
            this.logger.debug("Skipping [{}] as the event is already cancelled.", (Object)this.getName());
            return null;
        }
        if (!job.getRequest().isInteractive()) {
            this.logger.warn("XClass deleting listener will not check the document in non-interactive mode.");
            return null;
        }
        Map concernedEntities = (Map)data;
        XClassBreakingQuestion question = new XClassBreakingQuestion(concernedEntities);
        ArrayList entitySelectionsList = new ArrayList(concernedEntities.values());
        Collections.sort(entitySelectionsList);
        for (EntitySelection entitySelection : entitySelectionsList) {
            if (!(entitySelection.getEntityReference() instanceof DocumentReference)) continue;
            this.checkIfDeleteIsAllowed(entitySelection, question);
        }
        return question;
    }

    public void onEvent(Event event, Object source, Object data) {
        Job job = (Job)source;
        CancelableEvent cancelableEvent = (CancelableEvent)event;
        XClassBreakingQuestion question = this.buildQuestion(job, cancelableEvent, data);
        if (question == null) {
            return;
        }
        if (!question.getImpactedObjects().isEmpty()) {
            JobStatus jobStatus = job.getStatus();
            try {
                if (this.documentAccessBridge.isAdvancedUser((EntityReference)job.getRequest().getProperty("user.reference"))) {
                    question.unselectAll();
                    ack = job.getStatus().ask((Object)question, 5L, TimeUnit.MINUTES);
                    if (!ack) {
                        String message = "The question has been asked, however no answer has been received.";
                        this.logger.warn(message);
                        cancelableEvent.cancel(message);
                    }
                } else {
                    question.setRefactoringForbidden(true);
                    ack = jobStatus.ask((Object)question, 1L, TimeUnit.MINUTES);
                    if (!ack) {
                        String message = "The question has been canceled because this refactoring is forbidden.";
                        cancelableEvent.cancel(message);
                    }
                }
            }
            catch (InterruptedException e) {
                this.logger.warn("Confirm question has been interrupted.");
                cancelableEvent.cancel("Question has been interrupted.");
            }
            if (jobStatus instanceof CancelableJobStatus) {
                CancelableJobStatus cancelableJobStatus = (CancelableJobStatus)jobStatus;
                if (cancelableJobStatus.isCanceled()) {
                    cancelableEvent.cancel();
                }
                if (cancelableEvent.isCanceled()) {
                    cancelableJobStatus.cancel();
                }
            }
        }
    }

    private void checkIfDeleteIsAllowed(EntitySelection entitySelection, XClassBreakingQuestion question) {
        int queryLimit = 25;
        DocumentReference classReference = (DocumentReference)entitySelection.getEntityReference();
        if (classReference.getLocale() == null || Locale.ROOT.equals(classReference.getLocale())) {
            String className = (String)this.localSerializer.serialize((EntityReference)classReference, new Object[0]);
            try {
                List results = this.queryManager.createQuery(QUERY, "hql").setLimit(queryLimit).bindValue("className", (Object)className).setWiki(classReference.getWikiReference().getName()).execute();
                if (results.isEmpty()) {
                    question.markAsFreePage(entitySelection);
                } else {
                    if (results.size() == queryLimit) {
                        question.setObjectsPotentiallyHidden(true);
                    }
                    for (String documentObjectName : results) {
                        EntityReference documentObjectReference = this.resolver.resolve((Object)documentObjectName, EntityType.DOCUMENT, new Object[]{classReference});
                        question.markImpactedObject(entitySelection, documentObjectReference);
                    }
                }
            }
            catch (QueryException e) {
                this.logger.error("Error while executing query to retrieve objects linked to an XClass.", (Throwable)e);
            }
        }
    }
}

