/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.job;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.refactoring.job.question.EntitySelection;

public class XClassBreakingQuestion {
    private Map<EntityReference, EntitySelection> concernedEntities;
    private Map<EntityReference, Set<EntityReference>> impactedObjects;
    private Set<EntitySelection> xclassPages;
    private Set<EntitySelection> freePages;
    private boolean refactoringForbidden;
    private boolean objectsPotentiallyHidden;

    public XClassBreakingQuestion(Map<EntityReference, EntitySelection> concernedEntities) {
        this.concernedEntities = concernedEntities;
        this.impactedObjects = new LinkedHashMap<EntityReference, Set<EntityReference>>();
        this.freePages = new LinkedHashSet<EntitySelection>();
        this.xclassPages = new LinkedHashSet<EntitySelection>();
    }

    public void markAsFreePage(EntitySelection entitySelection) {
        this.freePages.add(entitySelection);
    }

    public void markImpactedObject(EntitySelection entitySelection, EntityReference documentObjectName) {
        DocumentReference xclassDocReference = (DocumentReference)entitySelection.getEntityReference();
        if (xclassDocReference.getLocale() != null) {
            xclassDocReference = new DocumentReference((EntityReference)xclassDocReference, (Locale)null);
        }
        if (!this.impactedObjects.containsKey(xclassDocReference)) {
            this.impactedObjects.put((EntityReference)xclassDocReference, new LinkedHashSet());
            this.xclassPages.add(entitySelection);
        }
        this.impactedObjects.get(xclassDocReference).add(documentObjectName);
    }

    public Map<EntityReference, Set<EntityReference>> getImpactedObjects() {
        return this.impactedObjects;
    }

    public void unselectAll() {
        for (EntitySelection entitySelection : this.concernedEntities.values()) {
            if (entitySelection.getState() != EntitySelection.State.UNKNOWN) continue;
            entitySelection.setSelected(false);
        }
    }

    public Set<EntitySelection> getXClassPages() {
        return this.xclassPages;
    }

    public Set<EntitySelection> getFreePages() {
        return this.freePages;
    }

    public void setSelectedDocuments(Set<DocumentReference> documents) {
        for (DocumentReference document : documents) {
            EntitySelection entitySelection = this.concernedEntities.get(document);
            if (entitySelection == null) continue;
            entitySelection.setSelected(true);
        }
    }

    public void selectAllFreePages() {
        for (EntitySelection entitySelection : this.freePages) {
            entitySelection.setSelected(true);
        }
    }

    public void setSelectAllFreePages(boolean select) {
        if (select) {
            this.selectAllFreePages();
        }
    }

    public boolean isRefactoringForbidden() {
        return this.refactoringForbidden;
    }

    public void setRefactoringForbidden(boolean refactoringForbidden) {
        this.refactoringForbidden = refactoringForbidden;
    }

    public boolean isObjectsPotentiallyHidden() {
        return this.objectsPotentiallyHidden;
    }

    public void setObjectsPotentiallyHidden(boolean objectsPotentiallyHidden) {
        this.objectsPotentiallyHidden = objectsPotentiallyHidden;
    }

    public Map<EntityReference, EntitySelection> getConcernedEntities() {
        return this.concernedEntities;
    }
}

