/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.LargeStringProperty;
import com.xpn.xwiki.objects.PropertyInterface;
import com.xpn.xwiki.objects.classes.BaseClass;
import com.xpn.xwiki.objects.classes.TextAreaClass;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.job.Job;
import org.xwiki.job.JobContext;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.localization.LocalizationManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.refactoring.ReferenceRenamer;
import org.xwiki.refactoring.internal.ReferenceUpdater;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.parser.ContentParser;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.user.CurrentUserReference;
import org.xwiki.user.UserReferenceResolver;

@Component
@Singleton
public class DefaultReferenceUpdater
implements ReferenceUpdater {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private ReferenceRenamer renamer;
    @Inject
    private ContentParser contentParser;
    @Inject
    private JobProgressManager progressManager;
    @Inject
    private JobContext jobcontext;
    @Inject
    private Logger logger;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;
    @Inject
    private UserReferenceResolver<CurrentUserReference> userReferenceResolver;
    @Inject
    private LocalizationManager localizationManager;

    private boolean isVerbose() {
        Job job = this.jobcontext.getCurrentJob();
        if (job != null) {
            return job.getRequest().isVerbose();
        }
        return false;
    }

    private String renderXDOM(XDOM content, BlockRenderer renderer) {
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        renderer.render((Block)content, (WikiPrinter)printer);
        return printer.toString();
    }

    private void saveDocumentPreservingAuthors(XWikiDocument document, String commentTranslationKey) throws XWikiException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        document.setContentDirty(false);
        document.setMetaDataDirty(true);
        document.getAuthors().setOriginalMetadataAuthor(this.userReferenceResolver.resolve((Object)CurrentUserReference.INSTANCE, new Object[0]));
        Locale defaultLocale = this.localizationManager.getDefaultLocale();
        String comment = this.localizationManager.getTranslationPlain(commentTranslationKey, defaultLocale, new Object[0]);
        xcontext.getWiki().saveDocument(document, comment, true, xcontext);
    }

    private boolean renameLinks(XWikiDocument document, boolean relative, RenameLambda renameLambda) throws XWikiException {
        XDOM xdom = document.getXDOM();
        if (renameLambda.call(xdom, document.getDocumentReference(), relative)) {
            document.setContent(xdom);
            return true;
        }
        return false;
    }

    private boolean renameLinks(BaseObject xobject, XWikiDocument document, BlockRenderer renderer, XWikiContext xcontext, boolean relative, RenameLambda renameLambda) {
        boolean modified = false;
        BaseClass xclass = xobject.getXClass(xcontext);
        for (Object fieldClass : xclass.getProperties()) {
            TextAreaClass textAreaClass;
            PropertyInterface field;
            if (!(fieldClass instanceof TextAreaClass) || !((TextAreaClass)fieldClass).isWikiContent() || !((field = xobject.getField((textAreaClass = (TextAreaClass)fieldClass).getName())) instanceof LargeStringProperty)) continue;
            LargeStringProperty largeField = (LargeStringProperty)field;
            try {
                XDOM xdom = this.contentParser.parse(largeField.getValue(), document.getSyntax(), (EntityReference)document.getDocumentReference());
                if (!renameLambda.call(xdom, document.getDocumentReference(), relative)) continue;
                largeField.setValue((Object)this.renderXDOM(xdom, renderer));
                modified = true;
            }
            catch (Exception e) {
                this.logger.warn("Failed to rename links from xobject property [{}], skipping it. Error: {}", (Object)largeField.getReference(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return modified;
    }

    private void info(String format, Object ... arguments) {
        if (this.isVerbose()) {
            this.logger.info(format, arguments);
        } else {
            this.logger.debug(format, arguments);
        }
    }

    private void maybeSaveDocumentPreservingAuthors(XWikiDocument documentToModify, boolean modified, DocumentReference currentDocumentReference, boolean relative, EntityReference oldTarget, EntityReference newTarget) throws XWikiException {
        if (modified) {
            if (relative) {
                this.saveDocumentPreservingAuthors(documentToModify, "refactoring.referenceUpdater.saveMessage.relativeLink");
                this.info("Updated the relative links from [{}].", currentDocumentReference);
            } else {
                this.saveDocumentPreservingAuthors(documentToModify, "refactoring.referenceUpdater.saveMessage.backlinks");
                this.info("The links from [{}] that were targeting [{}] have been updated to target [{}].", documentToModify.getDocumentReferenceWithLocale(), oldTarget, newTarget);
            }
        } else if (relative) {
            this.info("No relative links to update in [{}].", currentDocumentReference);
        } else {
            this.info("No back-links to update in [{}].", currentDocumentReference);
        }
    }

    private void renameLinks(XWikiDocument document, EntityReference oldTarget, EntityReference newTarget, XWikiContext xcontext, boolean relative, RenameLambda renameLambda) throws XWikiException {
        BlockRenderer renderer;
        DocumentReference currentDocumentReference = document.getDocumentReference();
        ComponentManager componentManager = (ComponentManager)this.contextComponentManagerProvider.get();
        if (!componentManager.hasComponent(BlockRenderer.class, document.getSyntax().toIdString())) {
            this.logger.warn("We can't rename the links from [{}] because there is no renderer available for its syntax [{}].", (Object)currentDocumentReference, (Object)document.getSyntax());
            return;
        }
        try {
            renderer = (BlockRenderer)componentManager.getInstance(BlockRenderer.class, document.getSyntax().toIdString());
        }
        catch (ComponentLookupException e) {
            this.logger.error("We can't rename the links from [{}] because the renderer for syntax [{}] cannot be loaded.", new Object[]{currentDocumentReference, document.getSyntax(), e});
            return;
        }
        XWikiDocument documentToModify = document.isCached() ? document.clone() : document;
        boolean modified = this.renameLinks(documentToModify, relative, renameLambda);
        for (List xobjects : documentToModify.getXObjects().values()) {
            for (BaseObject xobject : xobjects) {
                if (xobject == null) continue;
                modified |= this.renameLinks(xobject, documentToModify, renderer, xcontext, relative, renameLambda);
            }
        }
        this.maybeSaveDocumentPreservingAuthors(documentToModify, modified, currentDocumentReference, relative, oldTarget, newTarget);
    }

    private void renameLinks(DocumentReference documentReference, DocumentReference oldLinkTarget, DocumentReference newLinkTarget, boolean relative, Map<EntityReference, EntityReference> updatedEntities) {
        this.internalRenameLinks(documentReference, (EntityReference)oldLinkTarget, (EntityReference)newLinkTarget, relative, (xdom, currentDocumentReference, r) -> this.renamer.renameReferences((Block)xdom, currentDocumentReference, oldLinkTarget, newLinkTarget, r, updatedEntities));
    }

    private void renameLinks(DocumentReference documentReference, AttachmentReference oldLinkTarget, AttachmentReference newLinkTarget, boolean relative, Map<EntityReference, EntityReference> updatedEntities) {
        this.internalRenameLinks(documentReference, (EntityReference)oldLinkTarget, (EntityReference)newLinkTarget, relative, (xdom, currentDocumentReference, r) -> this.renamer.renameReferences((Block)xdom, currentDocumentReference, oldLinkTarget, newLinkTarget, r, updatedEntities));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRenameLinks(DocumentReference documentReference, EntityReference oldLinkTarget, EntityReference newLinkTarget, boolean relative, RenameLambda renameLambda) {
        boolean popLevelProgress = false;
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        String previousWikiId = xcontext.getWikiId();
        try {
            xcontext.setWikiId(documentReference.getWikiReference().getName());
            XWikiDocument document = xcontext.getWiki().getDocument(documentReference, xcontext);
            List locales = document.getTranslationLocales(xcontext);
            this.progressManager.pushLevelProgress(1 + locales.size(), (Object)this);
            popLevelProgress = true;
            this.progressManager.startStep((Object)this);
            this.renameLinks(document, oldLinkTarget, newLinkTarget, xcontext, relative, renameLambda);
            this.progressManager.endStep((Object)this);
            if (documentReference.getLocale() == null) {
                for (Locale locale : locales) {
                    this.progressManager.startStep((Object)this);
                    this.renameLinks(document.getTranslatedDocument(locale, xcontext), oldLinkTarget, newLinkTarget, xcontext, relative, renameLambda);
                    this.progressManager.endStep((Object)this);
                }
            }
        }
        catch (XWikiException e) {
            this.logger.error("Failed to rename the links that target [{}] from [{}].", new Object[]{oldLinkTarget, documentReference, e});
        }
        finally {
            if (popLevelProgress) {
                this.progressManager.popLevelProgress((Object)this);
            }
            xcontext.setWikiId(previousWikiId);
        }
    }

    private DocumentReference toDocumentReference(EntityReference entityReference) {
        return entityReference instanceof DocumentReference ? (DocumentReference)entityReference : new DocumentReference(entityReference);
    }

    private AttachmentReference toAttachmentReference(EntityReference entityReference) {
        return entityReference instanceof AttachmentReference ? (AttachmentReference)entityReference : new AttachmentReference(entityReference);
    }

    public void update(DocumentReference documentReference, EntityReference oldTargetReference, EntityReference newTargetReference, Map<EntityReference, EntityReference> updatedEntities) {
        boolean relative = newTargetReference.equals((Object)documentReference);
        if (oldTargetReference.getType() != newTargetReference.getType()) {
            return;
        }
        if (oldTargetReference.getType() == EntityType.ATTACHMENT) {
            this.renameLinks(documentReference, this.toAttachmentReference(oldTargetReference), this.toAttachmentReference(newTargetReference), relative, updatedEntities);
        } else if (oldTargetReference.getType() == EntityType.DOCUMENT) {
            this.renameLinks(documentReference, this.toDocumentReference(oldTargetReference), this.toDocumentReference(newTargetReference), relative, updatedEntities);
        }
    }

    public void update(DocumentReference documentReference, EntityReference oldTargetReference, EntityReference newTargetReference) {
        this.update(documentReference, oldTargetReference, newTargetReference, Map.of(oldTargetReference, newTargetReference));
    }

    @FunctionalInterface
    private static interface RenameLambda {
        public boolean call(XDOM var1, DocumentReference var2, boolean var3);
    }
}

