/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.refactoring.RefactoringConfiguration;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultRefactoringConfiguration
implements RefactoringConfiguration {
    private static final String IS_RECYCLE_BIN_SKIPPING_ACTIVATED_PROPERTY = "isRecycleBinSkippingActivated";
    private static final String PREFIX = "refactoring.";
    @Inject
    @Named(value="refactoring")
    private ConfigurationSource currentWikiConfigurationSource;
    @Inject
    @Named(value="refactoringmainwiki")
    private ConfigurationSource mainWikiConfigurationSource;
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource xwikiPropertiesSource;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    public boolean isRecycleBinSkippingActivated() {
        return this.defaultPropertyAccess(IS_RECYCLE_BIN_SKIPPING_ACTIVATED_PROPERTY, false);
    }

    private <T> T defaultPropertyAccess(String property, T defaultValue) {
        Object ret = this.currentWikiConfigurationSource.getProperty(property, defaultValue.getClass());
        if (ret == null && !this.isMainWiki()) {
            ret = this.mainWikiConfigurationSource.getProperty(property, defaultValue.getClass());
        }
        if (ret == null) {
            ret = this.xwikiPropertiesSource.getProperty(PREFIX + property, defaultValue);
        }
        return (T)ret;
    }

    private boolean isMainWiki() {
        return this.wikiDescriptorManager.isMainWiki(this.wikiDescriptorManager.getCurrentWikiId());
    }
}

