/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.script;

import com.xpn.xwiki.XWikiContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.ratings.AverageRating;
import org.xwiki.ratings.Rating;
import org.xwiki.ratings.RatingsConfiguration;
import org.xwiki.ratings.RatingsException;
import org.xwiki.ratings.RatingsManager;
import org.xwiki.ratings.script.RatingsScriptServiceAPI;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

public abstract class AbstractScriptRatingsManager
implements RatingsScriptServiceAPI {
    @Inject
    protected Logger logger;
    private RatingsManager ratingsManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> userReferenceResolver;
    @Inject
    private ContextualAuthorizationManager authorizationManager;

    void setRatingsManager(RatingsManager ratingsManager) {
        this.ratingsManager = ratingsManager;
    }

    private UserReference getCurrentUserReference() {
        return this.userReferenceResolver.resolve((Object)((XWikiContext)this.contextProvider.get()).getUserReference(), new Object[0]);
    }

    @Override
    public Optional<Rating> setRating(EntityReference reference, int vote) {
        return this.setRating(reference, this.getCurrentUserReference(), vote);
    }

    @Override
    public Optional<Rating> setRating(EntityReference reference, UserReference userReference, int vote) {
        Optional<Rating> result = Optional.empty();
        if (!this.isExcludedFromRatings(reference)) {
            try {
                Rating rating = this.ratingsManager.saveRating(reference, userReference, vote);
                if (rating != null) {
                    result = Optional.of(rating);
                }
            }
            catch (RatingsException e) {
                this.logger.error("Error while trying to rate reference [{}].", (Object)reference, (Object)ExceptionUtils.getRootCause((Throwable)e));
            }
        }
        return result;
    }

    @Override
    public List<Rating> getRatings(EntityReference reference, int offset, int limit) {
        return this.getRatings(reference, offset, limit, false);
    }

    @Override
    public List<Rating> getRatings(EntityReference reference, int offset, int limit, boolean asc) {
        try {
            HashMap<RatingsManager.RatingQueryField, Object> queryParameters = new HashMap<RatingsManager.RatingQueryField, Object>();
            queryParameters.put(RatingsManager.RatingQueryField.ENTITY_REFERENCE, reference);
            return this.ratingsManager.getRatings(queryParameters, offset, limit, RatingsManager.RatingQueryField.UPDATED_DATE, asc);
        }
        catch (RatingsException e) {
            this.logger.error("Error when getting ratings for reference [{}].", (Object)reference, (Object)ExceptionUtils.getRootCause((Throwable)e));
            return Collections.emptyList();
        }
    }

    @Override
    public Optional<AverageRating> getAverageRating(EntityReference reference) {
        try {
            return Optional.of(this.ratingsManager.getAverageRating(reference));
        }
        catch (RatingsException e) {
            this.logger.error("Error when getting average rating for reference [{}]", (Object)reference, (Object)ExceptionUtils.getRootCause((Throwable)e));
            return Optional.empty();
        }
    }

    @Override
    public Optional<AverageRating> recomputeAverageRating(EntityReference reference) {
        if (this.authorizationManager.hasAccess(Right.PROGRAM)) {
            try {
                return Optional.of(this.ratingsManager.recomputeAverageRating(reference));
            }
            catch (RatingsException e) {
                this.logger.error("Error when computing average rating for reference [{}]", (Object)reference, (Object)ExceptionUtils.getRootCause((Throwable)e));
            }
        } else {
            this.logger.warn("Recomputation of average rating is not authorized for users without programming rights. The script in [{}] cannot be executed properly.", (Object)((XWikiContext)this.contextProvider.get()).getDoc().getDocumentReference());
        }
        return Optional.empty();
    }

    @Override
    public Optional<Rating> getRating(EntityReference reference, UserReference author) {
        Optional<Rating> result = Optional.empty();
        HashMap<RatingsManager.RatingQueryField, Object> queryParameters = new HashMap<RatingsManager.RatingQueryField, Object>();
        queryParameters.put(RatingsManager.RatingQueryField.ENTITY_REFERENCE, reference);
        queryParameters.put(RatingsManager.RatingQueryField.USER_REFERENCE, author);
        try {
            List<Rating> ratings = this.ratingsManager.getRatings(queryParameters, 0, 1, RatingsManager.RatingQueryField.UPDATED_DATE, false);
            if (!ratings.isEmpty()) {
                result = Optional.of(ratings.get(0));
            }
        }
        catch (RatingsException e) {
            this.logger.error("Error when getting rating for reference [{}] by user [{}].", new Object[]{reference, author, ExceptionUtils.getRootCause((Throwable)e)});
        }
        return result;
    }

    @Override
    public List<Rating> getCurrentUserRatings(int offset, int limit, boolean asc) {
        List<Rating> result;
        HashMap<RatingsManager.RatingQueryField, Object> queryParameters = new HashMap<RatingsManager.RatingQueryField, Object>();
        queryParameters.put(RatingsManager.RatingQueryField.USER_REFERENCE, this.getCurrentUserReference());
        try {
            result = this.ratingsManager.getRatings(queryParameters, offset, limit, RatingsManager.RatingQueryField.UPDATED_DATE, asc);
        }
        catch (RatingsException e) {
            this.logger.error("Error when getting ratings of user [{}].", (Object)this.getCurrentUserReference(), (Object)ExceptionUtils.getRootCause((Throwable)e));
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public RatingsConfiguration getConfiguration() {
        return this.ratingsManager.getRatingConfiguration();
    }

    @Override
    public boolean isExcludedFromRatings(EntityReference entityReference) {
        boolean result = false;
        for (EntityReference excludedReference : this.ratingsManager.getRatingConfiguration().getExcludedReferencesFromRatings()) {
            if (!entityReference.equals((Object)excludedReference) && !entityReference.hasParent(excludedReference)) continue;
            result = true;
            break;
        }
        return result;
    }
}

