/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.internal.migration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.ratings.RatingsManager;
import org.xwiki.search.solr.Solr;
import org.xwiki.search.solr.SolrException;
import org.xwiki.search.solr.SolrUtils;
import org.xwiki.search.solr.XWikiSolrCore;
import org.xwiki.user.UserReference;

@Component(roles={SolrDocumentMigration120900000.class})
@Singleton
public class SolrDocumentMigration120900000 {
    private static final int BATCH_MIGRATION_SIZE = 100;
    private static final String OLD_PARENT_FIELD = "parent";
    private static final String OLD_DATE_FIELD = "date";
    @Inject
    private Logger logger;
    @Inject
    private SolrUtils solrUtils;
    @Inject
    private Solr solr;

    private XWikiSolrCore getCore() throws SolrException {
        return this.solr.getCore("ratings");
    }

    public void migrateAllDocumentsFrom1207000000(XWikiSolrCore core, int scale, String managerId) throws SolrException {
        SolrDocumentList documentList;
        int startIndex = 0;
        int totalMigrated = 0;
        long totalNumber = 0L;
        do {
            SolrQuery solrQuery = new SolrQuery("*").setStart(Integer.valueOf(startIndex)).setRows(Integer.valueOf(100)).setSort(OLD_DATE_FIELD, SolrQuery.ORDER.asc);
            try {
                QueryResponse queryResponse = core.getClient().query((SolrParams)solrQuery);
                documentList = queryResponse.getResults();
                totalNumber = queryResponse.getResults().getNumFound();
                for (SolrDocument solrDocument : documentList) {
                    this.migrateDocumentFrom120700000(solrDocument, scale, managerId);
                }
                startIndex += 100;
                this.logger.info("[{}] {} information migrated.", (Object)(totalMigrated += documentList.size()), (Object)managerId);
            }
            catch (IOException | SolrServerException e) {
                throw new SolrException("Error when executing query to perform 120700000 documents migration", (Exception)e);
            }
        } while (!documentList.isEmpty() && (long)totalMigrated < totalNumber);
        try {
            this.getCore().getClient().commit();
        }
        catch (IOException | SolrServerException e) {
            throw new SolrException("Error when committing after performing 120700000 documents migration.", (Exception)e);
        }
    }

    private void migrateDocumentFrom120700000(SolrDocument solrDocument, int scale, String managerId) throws SolrException {
        String id = this.solrUtils.getId(solrDocument);
        Date date = (Date)this.solrUtils.get(OLD_DATE_FIELD, solrDocument);
        DocumentReference documentReference = (DocumentReference)this.solrUtils.get(OLD_PARENT_FIELD, solrDocument, DocumentReference.class);
        int vote = (Integer)this.solrUtils.get(RatingsManager.RatingQueryField.VOTE.getFieldName(), solrDocument);
        UserReference author = (UserReference)this.solrUtils.get(RatingsManager.RatingQueryField.USER_REFERENCE.getFieldName(), solrDocument, UserReference.class);
        SolrInputDocument solrInputDocument = new SolrInputDocument();
        this.solrUtils.setId((Object)id, solrInputDocument);
        this.solrUtils.set(RatingsManager.RatingQueryField.MANAGER_ID.getFieldName(), (Object)managerId, solrInputDocument);
        this.solrUtils.setString(RatingsManager.RatingQueryField.ENTITY_REFERENCE.getFieldName(), (Object)documentReference, EntityReference.class, solrInputDocument);
        ArrayList<EntityReference> parentReferenceList = new ArrayList<EntityReference>();
        for (EntityReference parentReference = documentReference.getParent(); parentReference != null; parentReference = parentReference.getParent()) {
            parentReferenceList.add(parentReference);
        }
        this.solrUtils.setString(RatingsManager.RatingQueryField.PARENTS_REFERENCE.getFieldName(), parentReferenceList, EntityReference.class, solrInputDocument);
        this.solrUtils.set(RatingsManager.RatingQueryField.SCALE.getFieldName(), (Object)scale, solrInputDocument);
        this.solrUtils.set(RatingsManager.RatingQueryField.VOTE.getFieldName(), (Object)vote, solrInputDocument);
        this.solrUtils.setString(RatingsManager.RatingQueryField.USER_REFERENCE.getFieldName(), (Object)author, UserReference.class, solrInputDocument);
        this.solrUtils.set(RatingsManager.RatingQueryField.CREATED_DATE.getFieldName(), (Object)date, solrInputDocument);
        this.solrUtils.set(RatingsManager.RatingQueryField.UPDATED_DATE.getFieldName(), (Object)date, solrInputDocument);
        try {
            this.getCore().getClient().add(solrInputDocument);
        }
        catch (IOException | SolrServerException e) {
            throw new SolrException("Error when adding new document for performing 120700000 document migration", (Exception)e);
        }
    }
}

