/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.internal.migration;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.common.params.SolrParams;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.ratings.RatingsException;
import org.xwiki.ratings.RatingsManager;
import org.xwiki.ratings.RatingsManagerFactory;
import org.xwiki.ratings.internal.DefaultRating;
import org.xwiki.ratings.internal.migration.SolrDocumentMigration120900000;
import org.xwiki.search.solr.Solr;
import org.xwiki.search.solr.SolrException;
import org.xwiki.search.solr.XWikiSolrCore;
import org.xwiki.user.UserReferenceResolver;

@Component
@Named(value="R120901000XWIKI17761")
@Singleton
public class R120901000XWIKI17761DataMigration
extends AbstractHibernateDataMigration {
    private static final int BATCH_SIZE_FOR_LOG = 100;
    private static final String LIKE_SOLR_CORE = "like";
    @Inject
    private RatingsManagerFactory ratingsManagerFactory;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private UserReferenceResolver<String> userReferenceResolver;
    @Inject
    private Solr solr;
    @Inject
    private SolrDocumentMigration120900000 solrDocumentMigration120900000;
    @Inject
    private Logger logger;
    private XWiki wiki;
    private DocumentReference ratingXClassReference;
    private String ratingManagerHint;
    private RatingsManager ratingsManager;
    private Set<DocumentReference> targetOfMigratedRating;
    private GlobalMigrationStatistics globalMigrationStatistics;

    public String getDescription() {
        return "Move old Ratings XObject to the default Solr rating store.";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(120901000);
    }

    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
        this.wiki = this.getXWikiContext().getWiki();
        String xwikiSpace = "XWiki";
        String wikiName = this.getXWikiContext().getWikiId();
        DocumentReference ratingsConfigurationReference = new DocumentReference(wikiName, xwikiSpace, "RatingsConfig");
        DocumentReference ratingsConfigXClassReference = new DocumentReference(wikiName, xwikiSpace, "RatingsConfigClass");
        this.ratingXClassReference = new DocumentReference(wikiName, xwikiSpace, "RatingsClass");
        XWikiDocument ratingsConfigurationDoc = this.wiki.getDocument(ratingsConfigurationReference, this.getXWikiContext());
        BaseObject ratingsConfig = ratingsConfigurationDoc.getXObject(ratingsConfigXClassReference);
        if (!ratingsConfigurationDoc.isNew() && ratingsConfig != null) {
            this.ratingManagerHint = ratingsConfig.getStringValue("managerHint");
            try {
                this.ratingsManager = this.ratingsManagerFactory.getRatingsManager("ratings");
                List pagesWithRatingXObject = (List)this.getStore().executeRead(this.getXWikiContext(), this::getAllPagesWithRatingXObject);
                this.globalMigrationStatistics = new GlobalMigrationStatistics(pagesWithRatingXObject.size());
                if (!pagesWithRatingXObject.isEmpty()) {
                    this.logger.info("[{}] pages containing ratings xobjects have been found: those objects will be migrated to the new storage system and will be removed. The pages holding those xobjects will remain", (Object)this.globalMigrationStatistics.numberOfPagesToHandle);
                }
                this.targetOfMigratedRating = new HashSet<DocumentReference>();
                for (String serializedReference : pagesWithRatingXObject) {
                    this.handlePage(serializedReference);
                }
                this.globalMigrationStatistics.displayAfterXObjectMigrationLog();
                this.handleAverageMigration();
                this.handleLikeMigration();
            }
            catch (RatingsException e) {
                throw new DataMigrationException("Cannot migrate old rating xobject to new storage system.", (Throwable)e);
            }
            catch (SolrException e) {
                throw new DataMigrationException("Error while migrating Like informations.", (Throwable)e);
            }
        }
    }

    private void handleLikeMigration() throws SolrException {
        if (this.getXWikiContext().isMainWiki()) {
            XWikiSolrCore likeCore = this.solr.getCore(LIKE_SOLR_CORE);
            if (likeCore != null) {
                try {
                    SolrQuery solrQuery = new SolrQuery("*").setStart(Integer.valueOf(0)).setRows(Integer.valueOf(1));
                    likeCore.getClient().query((SolrParams)solrQuery);
                }
                catch (Throwable e) {
                    likeCore = null;
                    this.logger.debug("Solr test connection for Like migration did not went well.", e);
                }
            }
            if (likeCore != null) {
                this.logger.info("Starting migration of Likes information to the Ratings Solr Core.");
                this.solrDocumentMigration120900000.migrateAllDocumentsFrom1207000000(likeCore, 1, LIKE_SOLR_CORE);
            }
            this.logger.info("The migration is now finished.");
        }
    }

    private void handleAverageMigration() throws RatingsException {
        this.logger.info("Starting recomputation of average ratings on rated pages for consistency of data.");
        AverageMigrationStatistics averageMigrationStatistics = new AverageMigrationStatistics();
        for (DocumentReference ratedDocumentReference : this.targetOfMigratedRating) {
            this.ratingsManager.recomputeAverageRating((EntityReference)ratedDocumentReference);
            averageMigrationStatistics.displayLog();
        }
        averageMigrationStatistics.displayLogAfterMigration();
    }

    private void handlePage(String serializedReference) throws XWikiException, RatingsException {
        DocumentReference reference = this.documentReferenceResolver.resolve((Object)serializedReference, new Object[0]);
        XWikiDocument document = this.wiki.getDocument(reference, this.getXWikiContext());
        boolean updatedDocument = false;
        List xObjects = document.getXObjects(this.ratingXClassReference);
        XObjectMigrationStatistics xObjectMigrationStatistics = new XObjectMigrationStatistics(serializedReference, xObjects.size());
        for (BaseObject xObject : xObjects) {
            updatedDocument = this.handleXObject(xObject, document, xObjectMigrationStatistics);
        }
        xObjectMigrationStatistics.handleNotMigrated();
        if (updatedDocument) {
            this.wiki.saveDocument(document, "Migration of Rating objects", true, this.getXWikiContext());
        }
        this.globalMigrationStatistics.displayPageLogMigration();
    }

    private boolean handleXObject(BaseObject xObject, XWikiDocument ownerDocument, XObjectMigrationStatistics xObjectMigrationStatistics) throws RatingsException {
        boolean result = false;
        boolean migratedXObject = this.migrateRatingXObject(xObject, ownerDocument.getDocumentReference());
        if (migratedXObject) {
            ownerDocument.removeXObject(xObject);
            result = true;
            ++xObjectMigrationStatistics.numberOfXObjectsMigrated;
        } else {
            ++xObjectMigrationStatistics.numberOfXObjecsNotMigrated;
        }
        xObjectMigrationStatistics.displayLog();
        this.globalMigrationStatistics.totalNumberOfXObjectsMigrated += xObjectMigrationStatistics.numberOfXObjectsMigrated;
        return result;
    }

    private boolean migrateRatingXObject(BaseObject xObject, DocumentReference ownerDocReference) throws RatingsException {
        boolean migrateRating;
        String author = xObject.getStringValue("author");
        Date date = xObject.getDateValue("date");
        String parent = xObject.getStringValue("parent");
        int vote = xObject.getIntValue("vote");
        DocumentReference ratedPage = this.documentReferenceResolver.resolve((Object)parent, new Object[0]);
        boolean bl = migrateRating = "separate".equals(this.ratingManagerHint) && !ratedPage.equals((Object)ownerDocReference) || "default".equals(this.ratingManagerHint) && ratedPage.equals((Object)ownerDocReference);
        if (migrateRating) {
            DefaultRating rating = new DefaultRating(UUID.randomUUID().toString()).setManagerId("ratings").setAuthor(this.userReferenceResolver.resolve((Object)author, new Object[0])).setReference((EntityReference)ratedPage).setCreatedAt(date).setUpdatedAt(date).setScaleUpperBound(5).setVote(vote);
            this.ratingsManager.saveRating(rating);
            this.targetOfMigratedRating.add(ratedPage);
        }
        return migrateRating;
    }

    private List<String> getAllPagesWithRatingXObject(Session session) throws HibernateException, XWikiException {
        Query query = session.createQuery("select distinct obj.name from BaseObject obj where obj.className = 'XWiki.RatingsClass'", String.class);
        return query.list();
    }

    private class GlobalMigrationStatistics {
        private final int numberOfPagesToHandle;
        private int numberOfPageHandled;
        private int totalNumberOfXObjectsMigrated;
        private final Map<String, Pair<Integer, Integer>> pagesWithNotMigratedRatings = new HashMap<String, Pair<Integer, Integer>>();

        GlobalMigrationStatistics(int numberOfPagesToHandle) {
            this.numberOfPagesToHandle = numberOfPagesToHandle;
        }

        void saveNotMigratedRatings(String serializedReference, int migrated, int notMigrated) {
            this.pagesWithNotMigratedRatings.put(serializedReference, (Pair<Integer, Integer>)new ImmutablePair((Object)migrated, (Object)notMigrated));
        }

        void displayPageLogMigration() {
            if (++this.numberOfPageHandled % 100 == 0) {
                R120901000XWIKI17761DataMigration.this.logger.info("[{}] pages have been handled for migrating their Ratings xobject on a total of [{}]", (Object)this.numberOfPageHandled, (Object)this.numberOfPagesToHandle);
            }
        }

        void displayAfterXObjectMigrationLog() {
            R120901000XWIKI17761DataMigration.this.logger.info("All pages have been handled to migrate their Ratings xobject. Total: [{}] pages handled and [{}] xobjects migrated.", (Object)this.numberOfPagesToHandle, (Object)this.totalNumberOfXObjectsMigrated);
            if (!this.pagesWithNotMigratedRatings.isEmpty()) {
                R120901000XWIKI17761DataMigration.this.logger.info("Some ratings xobject have not been migrated because of the ratings configuration. Here's the list of pages with ratings values not migrated: ");
                for (Map.Entry<String, Pair<Integer, Integer>> entry : this.pagesWithNotMigratedRatings.entrySet()) {
                    R120901000XWIKI17761DataMigration.this.logger.info("Page: [{}]. Migrated: [{}]. Not migrated: [{}]", new Object[]{entry.getKey(), entry.getValue().getLeft(), entry.getValue().getRight()});
                }
            }
        }
    }

    private class AverageMigrationStatistics {
        private int numberOfTargetPageHandled;
        private final int totalNumberOfTargetPageToHandle;

        AverageMigrationStatistics() {
            this.totalNumberOfTargetPageToHandle = R120901000XWIKI17761DataMigration.this.targetOfMigratedRating.size();
        }

        void displayLog() {
            if (++this.numberOfTargetPageHandled % 100 == 0) {
                R120901000XWIKI17761DataMigration.this.logger.info("Average rating have been recomputed on [{}] pages on a total of [{}]", (Object)this.numberOfTargetPageHandled, (Object)this.totalNumberOfTargetPageToHandle);
            }
        }

        void displayLogAfterMigration() {
            R120901000XWIKI17761DataMigration.this.logger.info("Average ratings have been recomputed on all [{}] pages.", (Object)this.totalNumberOfTargetPageToHandle);
        }
    }

    private class XObjectMigrationStatistics {
        private final String serializedReference;
        private final int numberOfXObjectsToHandle;
        private int numberOfXObjectsMigrated;
        private int numberOfXObjecsNotMigrated;
        private int numberOfXObjectHandled;

        XObjectMigrationStatistics(String serializedReference, int numberOfXObjectsToHandle) {
            this.serializedReference = serializedReference;
            this.numberOfXObjectsToHandle = numberOfXObjectsToHandle;
        }

        void displayLog() {
            if (++this.numberOfXObjectHandled % 100 == 0) {
                R120901000XWIKI17761DataMigration.this.logger.info("[{}] Ratings XObjects have been handled in document [{}] on a total of [{}]. ([{}] migrated and [{}] not migrated).", new Object[]{this.numberOfXObjectHandled, this.serializedReference, this.numberOfXObjectsToHandle, this.numberOfXObjectsMigrated, this.numberOfXObjecsNotMigrated});
            }
        }

        void handleNotMigrated() {
            if (this.numberOfXObjecsNotMigrated > 0) {
                R120901000XWIKI17761DataMigration.this.globalMigrationStatistics.saveNotMigratedRatings(this.serializedReference, this.numberOfXObjectsMigrated, this.numberOfXObjecsNotMigrated);
            }
        }
    }
}

