/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.internal.averagerating;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.event.Event;
import org.xwiki.properties.converter.Converter;
import org.xwiki.ratings.AverageRating;
import org.xwiki.ratings.RatingsException;
import org.xwiki.ratings.events.UpdateAverageRatingFailedEvent;
import org.xwiki.ratings.events.UpdatedAverageRatingEvent;
import org.xwiki.ratings.events.UpdatingAverageRatingEvent;
import org.xwiki.ratings.internal.averagerating.AbstractAverageRatingManager;
import org.xwiki.ratings.internal.averagerating.AverageRatingClassDocumentInitializer;
import org.xwiki.ratings.internal.averagerating.AverageRatingManager;
import org.xwiki.ratings.internal.averagerating.DefaultAverageRating;

@Component
@Named(value="xobject")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class XObjectAverageRatingManager
extends AbstractAverageRatingManager {
    private static final String MOVE_ERROR_MESSAGE = "Error while moving the average ratings from [%s] to [%s]";
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private Converter<EntityReference> entityReferenceConverter;
    @Inject
    private EntityReferenceSerializer<String> stringEntityReferenceSerializer;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private ContextualLocalizationManager contextualLocalizationManager;

    @Override
    public AverageRating getAverageRating(EntityReference entityReference) throws RatingsException {
        try {
            BaseObject baseObject = this.retrieveAverageRatingXObject(entityReference);
            if (baseObject == null) {
                return this.createAverageRating(entityReference, this.computeAverageRatingId(entityReference));
            }
            return this.transformXObjectToAverageRating(baseObject, entityReference);
        }
        catch (Exception e) {
            throw new RatingsException(String.format("Error while trying to get average rating from reference [%s]", entityReference), e);
        }
    }

    @Override
    public long removeAverageRatings(EntityReference entityReference) throws RatingsException {
        long result = 0L;
        if (entityReference.getType() != EntityType.WIKI) {
            try {
                BaseObject baseObject = this.retrieveAverageRatingXObject(entityReference);
                if (baseObject != null) {
                    XWikiDocument ownerDocument = baseObject.getOwnerDocument();
                    ownerDocument.removeXObject(baseObject);
                    XWikiContext context = (XWikiContext)this.contextProvider.get();
                    String comment = this.contextualLocalizationManager.getTranslationPlain("ratings.averagerating.manager.remove.comment", new Object[0]);
                    context.getWiki().saveDocument(ownerDocument, comment, true, context);
                    result = 1L;
                }
            }
            catch (Exception e) {
                throw new RatingsException(String.format("Error while trying to remove average ratings related to [%s]", entityReference), e);
            }
        }
        return result;
    }

    @Override
    public long moveAverageRatings(EntityReference oldReference, EntityReference newReference) throws RatingsException {
        ArrayList changedAverageRatings;
        block6: {
            if (oldReference == null || newReference == null || oldReference.extractReference(EntityType.DOCUMENT) == null || newReference.extractReference(EntityType.DOCUMENT) == null) {
                throw new RatingsException("Impossible to move the average ratings from [" + String.valueOf(oldReference) + "] to [" + String.valueOf(newReference) + "].");
            }
            changedAverageRatings = new ArrayList();
            try {
                XWikiDocument actualDoc = (XWikiDocument)this.documentAccessBridge.getDocumentInstance(newReference);
                for (BaseObject ratingsObject : actualDoc.getXObjects((EntityReference)AverageRatingClassDocumentInitializer.AVERAGE_RATINGS_CLASSREFERENCE)) {
                    if (ratingsObject == null) continue;
                    this.moveAverageRatingsObject(oldReference, newReference, ratingsObject).ifPresent(changedAverageRatings::add);
                }
                if (changedAverageRatings.isEmpty()) break block6;
                XWikiContext context = (XWikiContext)this.contextProvider.get();
                this.getObservationManager().notify((Event)new UpdatingAverageRatingEvent(), (Object)this.getIdentifier(), changedAverageRatings);
                try {
                    String comment = this.contextualLocalizationManager.getTranslationPlain("ratings.averagerating.manager.move.comment", new Object[0]);
                    context.getWiki().saveDocument(actualDoc, comment, true, context);
                    this.getObservationManager().notify((Event)new UpdatedAverageRatingEvent(), (Object)this.getIdentifier(), changedAverageRatings);
                }
                catch (XWikiException e) {
                    this.getObservationManager().notify((Event)new UpdateAverageRatingFailedEvent(), (Object)this.getIdentifier(), changedAverageRatings);
                    throw new RatingsException(String.format(MOVE_ERROR_MESSAGE, oldReference, newReference), e);
                }
            }
            catch (Exception e) {
                throw new RatingsException(String.format(MOVE_ERROR_MESSAGE, oldReference, newReference), e);
            }
        }
        return changedAverageRatings.size();
    }

    private Optional<AverageRating> moveAverageRatingsObject(EntityReference oldReference, EntityReference newReference, BaseObject averageRatingsObject) {
        Optional<AverageRating> averageRating;
        String xobjectManagerId = averageRatingsObject.getStringValue(AverageRatingManager.AverageRatingQueryField.MANAGER_ID.getFieldName());
        if (Objects.equals(this.getIdentifier(), xobjectManagerId)) {
            String xObjectOldReference = averageRatingsObject.getStringValue(AverageRatingManager.AverageRatingQueryField.ENTITY_REFERENCE.getFieldName());
            EntityReference xObjectOldEntityReference = (EntityReference)this.entityReferenceConverter.convert(EntityReference.class, (Object)xObjectOldReference);
            Object xObjectNewEntityReference = xObjectOldEntityReference.equals((Object)oldReference) ? newReference : (xObjectOldEntityReference.hasParent(oldReference) ? xObjectOldEntityReference.replaceParent(newReference) : null);
            if (xObjectNewEntityReference != null) {
                String xObjectNewReference = (String)this.entityReferenceConverter.convert(String.class, xObjectNewEntityReference);
                averageRatingsObject.setStringValue(AverageRatingManager.AverageRatingQueryField.ENTITY_REFERENCE.getFieldName(), xObjectNewReference);
                averageRating = Optional.of(this.transformXObjectToAverageRating(averageRatingsObject, (EntityReference)xObjectNewEntityReference));
            } else {
                averageRating = Optional.empty();
            }
        } else {
            averageRating = Optional.empty();
        }
        return averageRating;
    }

    private BaseObject retrieveAverageRatingXObject(EntityReference entityReference) throws Exception {
        DocumentModelBridge documentInstance = this.documentAccessBridge.getDocumentInstance(entityReference);
        XWikiDocument actualDoc = (XWikiDocument)documentInstance;
        String serializedReference = (String)this.entityReferenceConverter.convert(String.class, (Object)entityReference);
        for (BaseObject xObject : actualDoc.getXObjects((EntityReference)AverageRatingClassDocumentInitializer.AVERAGE_RATINGS_CLASSREFERENCE)) {
            if (xObject == null) continue;
            String xobjectReference = xObject.getStringValue(AverageRatingManager.AverageRatingQueryField.ENTITY_REFERENCE.getFieldName());
            String xobjectManagerId = xObject.getStringValue(AverageRatingManager.AverageRatingQueryField.MANAGER_ID.getFieldName());
            if (StringUtils.isEmpty((CharSequence)xobjectReference) && StringUtils.isEmpty((CharSequence)xobjectManagerId)) {
                return xObject;
            }
            if (!this.getIdentifier().equals(xobjectManagerId) || !serializedReference.equals(xobjectReference)) continue;
            return xObject;
        }
        return null;
    }

    private String computeAverageRatingId(EntityReference entityReference) {
        String serializedOwnerDocReference = (String)this.stringEntityReferenceSerializer.serialize(entityReference.extractReference(EntityType.DOCUMENT), new Object[0]);
        String managerId = this.getIdentifier();
        String serializedEntityReference = (String)this.stringEntityReferenceSerializer.serialize(entityReference, new Object[0]);
        String entityType = entityReference.getType().getLowerCase();
        return String.format("%s_%s", serializedOwnerDocReference, new HashCodeBuilder().append((Object)managerId).append((Object)serializedEntityReference).append((Object)entityType).toHashCode());
    }

    private AverageRating transformXObjectToAverageRating(BaseObject baseObject, EntityReference entityReference) {
        String averageId = this.computeAverageRatingId(entityReference);
        String managerId = this.getIdentifier();
        int totalVote = baseObject.getIntValue(AverageRatingManager.AverageRatingQueryField.TOTAL_VOTE.getFieldName());
        float averageVote = baseObject.getFloatValue(AverageRatingManager.AverageRatingQueryField.AVERAGE_VOTE.getFieldName());
        Date updatedDate = baseObject.getDateValue(AverageRatingManager.AverageRatingQueryField.UPDATED_AT.getFieldName());
        int scale = baseObject.getIntValue(AverageRatingManager.AverageRatingQueryField.SCALE.getFieldName(), 5);
        return new DefaultAverageRating(averageId).setManagerId(managerId).setReference(entityReference).setAverageVote(averageVote).setTotalVote(totalVote).setUpdatedAt(updatedDate).setScaleUpperBound(scale);
    }

    @Override
    public void saveAverageRating(AverageRating averageRating) throws RatingsException {
        try {
            EntityReference entityReference = averageRating.getReference();
            BaseObject baseObject = this.retrieveAverageRatingXObject(entityReference);
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            if (baseObject == null) {
                DocumentModelBridge documentInstance = this.documentAccessBridge.getDocumentInstance(entityReference);
                XWikiDocument actualDoc = (XWikiDocument)documentInstance;
                int xObjectNumber = actualDoc.createXObject((EntityReference)AverageRatingClassDocumentInitializer.AVERAGE_RATINGS_CLASSREFERENCE, context);
                baseObject = actualDoc.getXObject((EntityReference)AverageRatingClassDocumentInitializer.AVERAGE_RATINGS_CLASSREFERENCE, xObjectNumber);
            }
            String serializedEntityReference = (String)this.entityReferenceConverter.convert(String.class, (Object)entityReference);
            baseObject.setStringValue(AverageRatingManager.AverageRatingQueryField.MANAGER_ID.getFieldName(), this.getIdentifier());
            baseObject.setStringValue(AverageRatingManager.AverageRatingQueryField.ENTITY_REFERENCE.getFieldName(), serializedEntityReference);
            baseObject.setIntValue(AverageRatingManager.AverageRatingQueryField.TOTAL_VOTE.getFieldName(), averageRating.getNbVotes());
            baseObject.setFloatValue(AverageRatingManager.AverageRatingQueryField.AVERAGE_VOTE.getFieldName(), averageRating.getAverageVote());
            baseObject.setIntValue(AverageRatingManager.AverageRatingQueryField.SCALE.getFieldName(), this.getScale());
            baseObject.setDateValue(AverageRatingManager.AverageRatingQueryField.UPDATED_AT.getFieldName(), averageRating.getUpdatedAt());
            String comment = this.contextualLocalizationManager.getTranslationPlain("ratings.averagerating.manager.update.comment", new Object[0]);
            context.getWiki().saveDocument(baseObject.getOwnerDocument(), comment, true, context);
        }
        catch (Exception e) {
            throw new RatingsException(String.format("Error while saving Average Rating [%s].", averageRating), e);
        }
    }
}

