/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.internal.averagerating;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.ratings.AverageRating;
import org.xwiki.ratings.RatingsException;
import org.xwiki.ratings.RatingsManager;
import org.xwiki.ratings.internal.averagerating.AbstractAverageRatingManager;
import org.xwiki.ratings.internal.averagerating.AverageRatingManager;
import org.xwiki.ratings.internal.averagerating.DefaultAverageRating;
import org.xwiki.search.solr.Solr;
import org.xwiki.search.solr.SolrException;
import org.xwiki.search.solr.SolrUtils;

@Component
@Named(value="solr")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class SolrAverageRatingManager
extends AbstractAverageRatingManager {
    private static final int BULK_OPERATIONS_BATCH_SIZE = 100;
    private static final String FILTER_REFERENCE_OR_PARENTS = "filter(%s:%s) AND (filter(%s:%s) OR filter(%s:%s))";
    @Inject
    private SolrUtils solrUtils;
    @Inject
    private Solr solr;

    private SolrClient getAverageRatingSolrClient() throws SolrException {
        return this.solr.getClient("averageRating");
    }

    private SolrQuery.ORDER getOrder(boolean asc) {
        return asc ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc;
    }

    private SolrInputDocument getInputDocumentFromAverageRating(AverageRating averageRating) {
        SolrInputDocument result = new SolrInputDocument();
        this.solrUtils.setId((Object)averageRating.getId(), result);
        this.solrUtils.setString(AverageRatingManager.AverageRatingQueryField.ENTITY_REFERENCE.getFieldName(), (Object)averageRating.getReference(), EntityReference.class, result);
        ArrayList<EntityReference> parentReferences = new ArrayList<EntityReference>();
        for (EntityReference parent = averageRating.getReference(); parent != null; parent = parent.getParent()) {
            parentReferences.add(parent);
        }
        this.solrUtils.setString(AverageRatingManager.AverageRatingQueryField.PARENTS.getFieldName(), parentReferences, EntityReference.class, result);
        this.solrUtils.set(AverageRatingManager.AverageRatingQueryField.UPDATED_AT.getFieldName(), (Object)averageRating.getUpdatedAt(), result);
        this.solrUtils.set(AverageRatingManager.AverageRatingQueryField.TOTAL_VOTE.getFieldName(), (Object)averageRating.getNbVotes(), result);
        this.solrUtils.set(AverageRatingManager.AverageRatingQueryField.SCALE.getFieldName(), (Object)averageRating.getScaleUpperBound(), result);
        this.solrUtils.set(AverageRatingManager.AverageRatingQueryField.MANAGER_ID.getFieldName(), (Object)averageRating.getManagerId(), result);
        this.solrUtils.set(AverageRatingManager.AverageRatingQueryField.AVERAGE_VOTE.getFieldName(), (Object)Float.valueOf(averageRating.getAverageVote()), result);
        return result;
    }

    @Override
    public AverageRating getAverageRating(EntityReference entityReference) throws RatingsException {
        SolrQuery solrQuery = new SolrQuery().addFilterQuery(new String[]{String.format("filter(%s:%s) AND filter(%s:%s)", AverageRatingManager.AverageRatingQueryField.MANAGER_ID.getFieldName(), this.solrUtils.toCompleteFilterQueryString((Object)this.getIdentifier()), AverageRatingManager.AverageRatingQueryField.ENTITY_REFERENCE.getFieldName(), this.solrUtils.toCompleteFilterQueryString((Object)entityReference, EntityReference.class))}).setStart(Integer.valueOf(0)).setRows(Integer.valueOf(1)).setSort(AverageRatingManager.AverageRatingQueryField.UPDATED_AT.getFieldName(), this.getOrder(true));
        try {
            QueryResponse query = this.getAverageRatingSolrClient().query((SolrParams)solrQuery);
            if (query.getResults().isEmpty()) {
                return this.createAverageRating(entityReference, UUID.randomUUID().toString());
            }
            SolrDocument solrDocument = (SolrDocument)query.getResults().get(0);
            DefaultAverageRating result = new DefaultAverageRating(this.solrUtils.getId(solrDocument)).setManagerId((String)this.solrUtils.get(AverageRatingManager.AverageRatingQueryField.MANAGER_ID.getFieldName(), solrDocument)).setAverageVote(((Float)this.solrUtils.get(AverageRatingManager.AverageRatingQueryField.AVERAGE_VOTE.getFieldName(), solrDocument)).floatValue()).setReference(entityReference).setTotalVote((Integer)this.solrUtils.get(AverageRatingManager.AverageRatingQueryField.TOTAL_VOTE.getFieldName(), solrDocument)).setScaleUpperBound((Integer)this.solrUtils.get(AverageRatingManager.AverageRatingQueryField.SCALE.getFieldName(), solrDocument)).setUpdatedAt((Date)this.solrUtils.get(AverageRatingManager.AverageRatingQueryField.UPDATED_AT.getFieldName(), solrDocument));
            return result;
        }
        catch (IOException | SolrServerException | SolrException e) {
            throw new RatingsException("Error while trying to get average rating value.", e);
        }
    }

    @Override
    public long removeAverageRatings(EntityReference entityReference) throws RatingsException {
        long result;
        String escapedEntityReference = this.solrUtils.toCompleteFilterQueryString((Object)entityReference, EntityReference.class);
        String filterQuery = String.format(FILTER_REFERENCE_OR_PARENTS, AverageRatingManager.AverageRatingQueryField.MANAGER_ID.getFieldName(), this.solrUtils.toCompleteFilterQueryString((Object)this.getIdentifier()), AverageRatingManager.AverageRatingQueryField.ENTITY_REFERENCE.getFieldName(), escapedEntityReference, AverageRatingManager.AverageRatingQueryField.PARENTS.getFieldName(), escapedEntityReference);
        SolrQuery solrQuery = new SolrQuery().addFilterQuery(new String[]{filterQuery}).setStart(Integer.valueOf(0)).setRows(Integer.valueOf(0));
        try {
            QueryResponse query = this.getAverageRatingSolrClient().query((SolrParams)solrQuery);
            result = query.getResults().getNumFound();
            this.getAverageRatingSolrClient().deleteByQuery(filterQuery);
            this.getAverageRatingSolrClient().commit();
        }
        catch (IOException | SolrServerException | SolrException e) {
            throw new RatingsException("Error while trying to remove ratings", e);
        }
        return result;
    }

    @Override
    public long moveAverageRatings(EntityReference oldReference, EntityReference newReference) throws RatingsException {
        SolrDocumentList rawRatings;
        String escapedEntityReference = this.solrUtils.toCompleteFilterQueryString((Object)oldReference, EntityReference.class);
        String filterQuery = String.format(FILTER_REFERENCE_OR_PARENTS, AverageRatingManager.AverageRatingQueryField.MANAGER_ID.getFieldName(), this.solrUtils.toCompleteFilterQueryString((Object)this.getIdentifier()), AverageRatingManager.AverageRatingQueryField.ENTITY_REFERENCE.getFieldName(), escapedEntityReference, AverageRatingManager.AverageRatingQueryField.PARENTS.getFieldName(), escapedEntityReference);
        int offset = 0;
        long result = 0L;
        do {
            SolrQuery solrQuery = new SolrQuery().addFilterQuery(new String[]{filterQuery}).setStart(Integer.valueOf(offset)).setRows(Integer.valueOf(100)).setSort(AverageRatingManager.AverageRatingQueryField.UPDATED_AT.getFieldName(), this.getOrder(true));
            try {
                QueryResponse queryResponse = this.getAverageRatingSolrClient().query((SolrParams)solrQuery);
                rawRatings = queryResponse.getResults();
                offset += 100;
                for (SolrDocument rawRating : rawRatings) {
                    Collection parentReferences;
                    SolrInputDocument solrInputDocument = new SolrInputDocument();
                    this.solrUtils.setId((Object)this.solrUtils.getId(rawRating), solrInputDocument);
                    EntityReference ratingReference = (EntityReference)this.solrUtils.get(RatingsManager.RatingQueryField.ENTITY_REFERENCE.getFieldName(), rawRating, EntityReference.class);
                    if (oldReference.equals((Object)ratingReference)) {
                        this.solrUtils.setAtomic("set", RatingsManager.RatingQueryField.ENTITY_REFERENCE.getFieldName(), (Object)newReference, EntityReference.class, solrInputDocument);
                    }
                    if ((parentReferences = this.solrUtils.getCollection(RatingsManager.RatingQueryField.PARENTS_REFERENCE.getFieldName(), rawRating, EntityReference.class)).contains(oldReference)) {
                        this.solrUtils.setAtomic("remove", RatingsManager.RatingQueryField.PARENTS_REFERENCE.getFieldName(), (Object)oldReference, EntityReference.class, solrInputDocument);
                        this.solrUtils.setAtomic("add", RatingsManager.RatingQueryField.PARENTS_REFERENCE.getFieldName(), (Object)newReference, EntityReference.class, solrInputDocument);
                    }
                    this.getAverageRatingSolrClient().add(solrInputDocument);
                    ++result;
                }
                if (rawRatings.isEmpty()) continue;
                this.getAverageRatingSolrClient().commit();
            }
            catch (IOException | SolrServerException | SolrException e) {
                throw new RatingsException("Error while trying to update average rating reference", e);
            }
        } while (!rawRatings.isEmpty());
        return result;
    }

    @Override
    protected void saveAverageRating(AverageRating averageRating) throws RatingsException {
        try {
            this.getAverageRatingSolrClient().add(this.getInputDocumentFromAverageRating(averageRating));
            this.getAverageRatingSolrClient().commit();
        }
        catch (IOException | SolrServerException | SolrException e) {
            throw new RatingsException(String.format("Error when trying to save average rating [%s]", averageRating), e);
        }
    }
}

