/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.ratings.AverageRating;
import org.xwiki.ratings.Rating;
import org.xwiki.ratings.RatingsConfiguration;
import org.xwiki.ratings.RatingsException;
import org.xwiki.ratings.RatingsManager;
import org.xwiki.ratings.events.AbstractRatingEvent;
import org.xwiki.ratings.events.CreatedRatingEvent;
import org.xwiki.ratings.events.DeletedRatingEvent;
import org.xwiki.ratings.events.UpdatedRatingEvent;
import org.xwiki.ratings.internal.DefaultRating;
import org.xwiki.ratings.internal.averagerating.AverageRatingManager;
import org.xwiki.search.solr.Solr;
import org.xwiki.search.solr.SolrException;
import org.xwiki.search.solr.SolrUtils;
import org.xwiki.user.UserReference;

@Component
@Named(value="solr")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class SolrRatingsManager
implements RatingsManager {
    private static final int BULK_OPERATIONS_BATCH_SIZE = 100;
    private static final String FILTER_REFERENCE_OR_PARENTS = "filter(%s:%s) AND (filter(%s:%s) OR filter(%s:%s))";
    private static final String AVERAGE_RATING_NOT_ENABLED_ERROR_MESSAGE = "This rating manager is not configured to store average rating.";
    @Inject
    private SolrUtils solrUtils;
    @Inject
    private Solr solr;
    @Inject
    private ObservationManager observationManager;
    @Inject
    @Named(value="context")
    private ComponentManager contextComponentManager;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    private AverageRatingManager averageRatingManager;
    private RatingsConfiguration ratingsConfiguration;
    private String identifier;

    private SolrClient getRatingSolrClient() throws SolrException {
        if (this.getRatingConfiguration().hasDedicatedCore()) {
            return this.solr.getClient(this.getIdentifier());
        }
        return this.solr.getClient("ratings");
    }

    private AverageRatingManager getAverageRatingManager() throws RatingsException {
        if (this.averageRatingManager == null) {
            String averageRatingManagerHint = this.getRatingConfiguration().getAverageRatingStorageHint();
            try {
                this.averageRatingManager = (AverageRatingManager)this.contextComponentManager.getInstance(AverageRatingManager.class, averageRatingManagerHint);
                this.averageRatingManager.setRatingsManager(this);
            }
            catch (ComponentLookupException e) {
                throw new RatingsException(String.format("Cannot instantiate AverageRatingManager with hint [%s]", averageRatingManagerHint), e);
            }
        }
        return this.averageRatingManager;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public int getScale() {
        return this.getRatingConfiguration().getScaleUpperBound();
    }

    @Override
    public void setRatingConfiguration(RatingsConfiguration configuration) {
        this.ratingsConfiguration = configuration;
    }

    @Override
    public RatingsConfiguration getRatingConfiguration() {
        return this.ratingsConfiguration;
    }

    private SolrQuery.ORDER getOrder(boolean asc) {
        return asc ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc;
    }

    private Rating getRatingFromSolrDocument(SolrDocument document) {
        String ratingId = this.solrUtils.getId(document);
        String managerId = (String)this.solrUtils.get(RatingsManager.RatingQueryField.MANAGER_ID.getFieldName(), document);
        EntityReference entityReference = (EntityReference)this.solrUtils.get(RatingsManager.RatingQueryField.ENTITY_REFERENCE.getFieldName(), document, EntityReference.class);
        UserReference userReference = (UserReference)this.solrUtils.get(RatingsManager.RatingQueryField.USER_REFERENCE.getFieldName(), document, UserReference.class);
        int vote = (Integer)this.solrUtils.get(RatingsManager.RatingQueryField.VOTE.getFieldName(), document);
        Date createdAt = (Date)this.solrUtils.get(RatingsManager.RatingQueryField.CREATED_DATE.getFieldName(), document);
        Date updatedAt = (Date)this.solrUtils.get(RatingsManager.RatingQueryField.UPDATED_DATE.getFieldName(), document);
        int scale = (Integer)this.solrUtils.get(RatingsManager.RatingQueryField.SCALE.getFieldName(), document);
        return new DefaultRating(ratingId).setReference(entityReference).setAuthor(userReference).setVote(vote).setScaleUpperBound(scale).setCreatedAt(createdAt).setUpdatedAt(updatedAt).setManagerId(managerId);
    }

    private List<Rating> getRatingsFromQueryResult(SolrDocumentList documents) {
        if (documents != null) {
            return documents.stream().map(this::getRatingFromSolrDocument).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private String mapToQuery(Map<RatingsManager.RatingQueryField, Object> originalParameters) {
        LinkedHashMap<RatingsManager.RatingQueryField, Object> queryParameters = new LinkedHashMap<RatingsManager.RatingQueryField, Object>(originalParameters);
        queryParameters.put(RatingsManager.RatingQueryField.MANAGER_ID, this.getIdentifier());
        StringBuilder result = new StringBuilder();
        Iterator iterator = queryParameters.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry queryParameter = iterator.next();
            result.append("filter(");
            result.append(((RatingsManager.RatingQueryField)((Object)queryParameter.getKey())).getFieldName());
            result.append(":");
            Object value = queryParameter.getValue();
            if (value instanceof String || value instanceof Date) {
                result.append(this.solrUtils.toCompleteFilterQueryString(value));
            } else if (value instanceof UserReference) {
                result.append(this.solrUtils.toCompleteFilterQueryString(value, UserReference.class));
            } else if (value instanceof EntityReference) {
                result.append(this.solrUtils.toCompleteFilterQueryString(value, EntityReference.class));
            } else if (value != null) {
                result.append(value);
            }
            result.append(")");
            if (!iterator.hasNext()) continue;
            result.append(" AND ");
        }
        return result.toString();
    }

    private SolrInputDocument getInputDocumentFromRating(Rating rating) {
        SolrInputDocument result = new SolrInputDocument();
        this.solrUtils.setId((Object)rating.getId(), result);
        this.solrUtils.setString(RatingsManager.RatingQueryField.ENTITY_REFERENCE.getFieldName(), (Object)rating.getReference(), EntityReference.class, result);
        this.solrUtils.set(RatingsManager.RatingQueryField.CREATED_DATE.getFieldName(), (Object)rating.getCreatedAt(), result);
        this.solrUtils.set(RatingsManager.RatingQueryField.UPDATED_DATE.getFieldName(), (Object)rating.getUpdatedAt(), result);
        this.solrUtils.setString(RatingsManager.RatingQueryField.USER_REFERENCE.getFieldName(), (Object)rating.getAuthor(), UserReference.class, result);
        ArrayList<EntityReference> parentReferenceList = new ArrayList<EntityReference>();
        for (EntityReference parentReference = rating.getReference().getParent(); parentReference != null; parentReference = parentReference.getParent()) {
            parentReferenceList.add(parentReference);
        }
        this.solrUtils.setString(RatingsManager.RatingQueryField.PARENTS_REFERENCE.getFieldName(), parentReferenceList, EntityReference.class, result);
        this.solrUtils.set(RatingsManager.RatingQueryField.SCALE.getFieldName(), (Object)rating.getScaleUpperBound(), result);
        this.solrUtils.set(RatingsManager.RatingQueryField.MANAGER_ID.getFieldName(), (Object)rating.getManagerId(), result);
        this.solrUtils.set(RatingsManager.RatingQueryField.VOTE.getFieldName(), (Object)rating.getVote(), result);
        return result;
    }

    private Optional<Rating> retrieveExistingRating(EntityReference reference, UserReference voter) throws RatingsException {
        LinkedHashMap<RatingsManager.RatingQueryField, Object> queryMap = new LinkedHashMap<RatingsManager.RatingQueryField, Object>();
        queryMap.put(RatingsManager.RatingQueryField.ENTITY_REFERENCE, reference);
        queryMap.put(RatingsManager.RatingQueryField.USER_REFERENCE, voter);
        List<Rating> ratings = this.getRatings(queryMap, 0, 1, RatingsManager.RatingQueryField.CREATED_DATE, true);
        if (ratings.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(ratings.get(0));
    }

    @Override
    public synchronized Rating saveRating(EntityReference reference, UserReference user, int vote) throws RatingsException {
        this.checkIfVoteValid(vote);
        this.checkIfDocumentExists(reference);
        Optional<Rating> existingRating = this.retrieveExistingRating(reference, user);
        boolean storeAverage = this.getRatingConfiguration().isAverageStored();
        AbstractRatingEvent event = null;
        DefaultRating result = null;
        Rating oldRating = null;
        if (!existingRating.isPresent()) {
            if (vote != 0 || this.getRatingConfiguration().isZeroStored()) {
                result = new DefaultRating(UUID.randomUUID().toString()).setManagerId(this.getIdentifier()).setReference(reference).setCreatedAt(new Date()).setUpdatedAt(new Date()).setVote(vote).setScaleUpperBound(this.getScale()).setAuthor(user);
                event = new CreatedRatingEvent(result);
            }
        } else {
            oldRating = existingRating.get();
            if (vote != 0 || this.getRatingConfiguration().isZeroStored()) {
                result = new DefaultRating(oldRating).setUpdatedAt(new Date()).setVote(vote);
                event = new UpdatedRatingEvent(result, oldRating.getVote());
            } else {
                this.removeRating(oldRating.getId());
            }
        }
        if (result != null) {
            SolrInputDocument solrInputDocument = this.getInputDocumentFromRating(result);
            try {
                this.getRatingSolrClient().add(solrInputDocument);
                this.getRatingSolrClient().commit();
                this.observationManager.notify((Event)event, (Object)this.getIdentifier(), (Object)result);
                if (storeAverage) {
                    if (oldRating == null) {
                        this.getAverageRatingManager().addVote(reference, vote);
                    } else {
                        this.getAverageRatingManager().updateVote(reference, oldRating.getVote(), vote);
                    }
                }
            }
            catch (IOException | SolrServerException | SolrException e) {
                throw new RatingsException(String.format("Error when storing rating information for entity [%s] with user [%s].", reference, user), e);
            }
        }
        return result;
    }

    @Override
    public List<Rating> getRatings(Map<RatingsManager.RatingQueryField, Object> queryParameters, int offset, int limit, RatingsManager.RatingQueryField orderBy, boolean asc) throws RatingsException {
        SolrDocumentList rawRatings = this.getRawRatings(queryParameters, offset, limit, orderBy, asc);
        return this.getRatingsFromQueryResult(rawRatings);
    }

    private SolrDocumentList getRawRatings(Map<RatingsManager.RatingQueryField, Object> queryParameters, int offset, int limit, RatingsManager.RatingQueryField orderBy, boolean asc) throws RatingsException {
        SolrQuery solrQuery = new SolrQuery().addFilterQuery(new String[]{this.mapToQuery(queryParameters)}).setStart(Integer.valueOf(offset)).setRows(Integer.valueOf(limit)).setSort(orderBy.getFieldName(), this.getOrder(asc));
        try {
            QueryResponse query = this.getRatingSolrClient().query((SolrParams)solrQuery);
            return query.getResults();
        }
        catch (IOException | SolrServerException | SolrException e) {
            throw new RatingsException("Error while trying to get ratings", e);
        }
    }

    @Override
    public long countRatings(Map<RatingsManager.RatingQueryField, Object> queryParameters) throws RatingsException {
        SolrQuery solrQuery = new SolrQuery().addFilterQuery(new String[]{this.mapToQuery(queryParameters)}).setStart(Integer.valueOf(0)).setRows(Integer.valueOf(0));
        try {
            QueryResponse query = this.getRatingSolrClient().query((SolrParams)solrQuery);
            return query.getResults().getNumFound();
        }
        catch (IOException | SolrServerException | SolrException e) {
            throw new RatingsException("Error while trying to get count of ratings", e);
        }
    }

    @Override
    public synchronized boolean removeRating(String ratingIdentifier) throws RatingsException {
        Map<RatingsManager.RatingQueryField, Object> queryMap = Collections.singletonMap(RatingsManager.RatingQueryField.IDENTIFIER, ratingIdentifier);
        List<Rating> ratings = this.getRatings(queryMap, 0, 1, RatingsManager.RatingQueryField.CREATED_DATE, true);
        if (!ratings.isEmpty()) {
            try {
                this.getRatingSolrClient().deleteById(ratingIdentifier);
                this.getRatingSolrClient().commit();
                Rating rating = ratings.get(0);
                this.observationManager.notify((Event)new DeletedRatingEvent(rating), (Object)this.getIdentifier(), (Object)rating);
                if (this.getRatingConfiguration().isAverageStored()) {
                    this.getAverageRatingManager().removeVote(rating.getReference(), rating.getVote());
                }
                return true;
            }
            catch (IOException | SolrServerException | SolrException e) {
                throw new RatingsException("Error while removing rating.", e);
            }
        }
        return false;
    }

    @Override
    public synchronized long removeRatings(EntityReference entityReference) throws RatingsException {
        long result;
        String escapedEntityReference = this.solrUtils.toCompleteFilterQueryString((Object)entityReference, EntityReference.class);
        String filterQuery = String.format(FILTER_REFERENCE_OR_PARENTS, RatingsManager.RatingQueryField.MANAGER_ID.getFieldName(), this.solrUtils.toCompleteFilterQueryString((Object)this.getIdentifier()), RatingsManager.RatingQueryField.ENTITY_REFERENCE.getFieldName(), escapedEntityReference, RatingsManager.RatingQueryField.PARENTS_REFERENCE.getFieldName(), escapedEntityReference);
        SolrQuery solrQuery = new SolrQuery().addFilterQuery(new String[]{filterQuery}).setStart(Integer.valueOf(0)).setRows(Integer.valueOf(0));
        try {
            QueryResponse query = this.getRatingSolrClient().query((SolrParams)solrQuery);
            result = query.getResults().getNumFound();
            this.getRatingSolrClient().deleteByQuery(filterQuery);
            this.getRatingSolrClient().commit();
            if (this.getRatingConfiguration().isAverageStored()) {
                this.getAverageRatingManager().removeAverageRatings(entityReference);
            }
        }
        catch (IOException | SolrServerException | SolrException e) {
            throw new RatingsException("Error while trying to remove ratings", e);
        }
        return result;
    }

    @Override
    public synchronized long moveRatings(EntityReference oldReference, EntityReference newReference) throws RatingsException {
        SolrDocumentList rawRatings;
        String escapedEntityReference = this.solrUtils.toCompleteFilterQueryString((Object)oldReference, EntityReference.class);
        String filterQuery = String.format(FILTER_REFERENCE_OR_PARENTS, RatingsManager.RatingQueryField.MANAGER_ID.getFieldName(), this.solrUtils.toCompleteFilterQueryString((Object)this.getIdentifier()), RatingsManager.RatingQueryField.ENTITY_REFERENCE.getFieldName(), escapedEntityReference, RatingsManager.RatingQueryField.PARENTS_REFERENCE.getFieldName(), escapedEntityReference);
        int offset = 0;
        long result = 0L;
        do {
            SolrQuery solrQuery = new SolrQuery().addFilterQuery(new String[]{filterQuery}).setStart(Integer.valueOf(offset)).setRows(Integer.valueOf(100)).setSort(RatingsManager.RatingQueryField.CREATED_DATE.getFieldName(), this.getOrder(true));
            try {
                QueryResponse queryResponse = this.getRatingSolrClient().query((SolrParams)solrQuery);
                rawRatings = queryResponse.getResults();
                offset += 100;
                for (SolrDocument rawRating : rawRatings) {
                    Collection parentReferences;
                    SolrInputDocument solrInputDocument = new SolrInputDocument();
                    this.solrUtils.setId((Object)this.solrUtils.getId(rawRating), solrInputDocument);
                    EntityReference ratingReference = (EntityReference)this.solrUtils.get(RatingsManager.RatingQueryField.ENTITY_REFERENCE.getFieldName(), rawRating, EntityReference.class);
                    if (oldReference.equals((Object)ratingReference)) {
                        this.solrUtils.setAtomic("set", RatingsManager.RatingQueryField.ENTITY_REFERENCE.getFieldName(), (Object)newReference, EntityReference.class, solrInputDocument);
                    }
                    if ((parentReferences = this.solrUtils.getCollection(RatingsManager.RatingQueryField.PARENTS_REFERENCE.getFieldName(), rawRating, EntityReference.class)).contains(oldReference)) {
                        this.solrUtils.setAtomic("remove", RatingsManager.RatingQueryField.PARENTS_REFERENCE.getFieldName(), (Object)oldReference, EntityReference.class, solrInputDocument);
                        this.solrUtils.setAtomic("add", RatingsManager.RatingQueryField.PARENTS_REFERENCE.getFieldName(), (Object)newReference, EntityReference.class, solrInputDocument);
                    }
                    this.getRatingSolrClient().add(solrInputDocument);
                    ++result;
                }
                if (rawRatings.isEmpty()) continue;
                this.getRatingSolrClient().commit();
            }
            catch (IOException | SolrServerException | SolrException e) {
                throw new RatingsException("Error while trying to update rating reference", e);
            }
        } while (!rawRatings.isEmpty());
        if (this.getRatingConfiguration().isAverageStored()) {
            this.getAverageRatingManager().moveAverageRatings(oldReference, newReference);
        }
        return result;
    }

    @Override
    public AverageRating getAverageRating(EntityReference entityReference) throws RatingsException {
        if (this.getRatingConfiguration().isAverageStored()) {
            return this.getAverageRatingManager().getAverageRating(entityReference);
        }
        throw new RatingsException(AVERAGE_RATING_NOT_ENABLED_ERROR_MESSAGE);
    }

    @Override
    public synchronized void saveRating(Rating rating) throws RatingsException {
        SolrInputDocument solrInputDocument = this.getInputDocumentFromRating(rating);
        try {
            this.getRatingSolrClient().add(solrInputDocument);
            this.getRatingSolrClient().commit();
        }
        catch (IOException | SolrServerException | SolrException e) {
            throw new RatingsException(String.format("Error when saving the given rating: [%s]", rating), e);
        }
    }

    @Override
    public synchronized AverageRating recomputeAverageRating(EntityReference entityReference) throws RatingsException {
        if (this.getRatingConfiguration().isAverageStored()) {
            List<Rating> ratings;
            LinkedHashMap<RatingsManager.RatingQueryField, Object> queryMap = new LinkedHashMap<RatingsManager.RatingQueryField, Object>();
            queryMap.put(RatingsManager.RatingQueryField.ENTITY_REFERENCE, entityReference);
            Long sumOfVotes = 0L;
            int numberOfVotes = 0;
            int offsetIndex = 0;
            do {
                ratings = this.getRatings(queryMap, offsetIndex, 100, RatingsManager.RatingQueryField.CREATED_DATE, true);
                sumOfVotes = sumOfVotes + ratings.stream().map(Rating::getVote).map(Long::valueOf).reduce(0L, Long::sum);
                numberOfVotes += ratings.size();
                offsetIndex += 100;
            } while (!ratings.isEmpty());
            float newAverage = numberOfVotes > 0 ? Float.valueOf(sumOfVotes.longValue()).floatValue() / (float)numberOfVotes : 0.0f;
            return this.getAverageRatingManager().resetAverageRating(entityReference, newAverage, numberOfVotes);
        }
        throw new RatingsException(AVERAGE_RATING_NOT_ENABLED_ERROR_MESSAGE);
    }

    private void checkIfVoteValid(int vote) throws RatingsException {
        if (vote < 0 || vote > this.getScale()) {
            throw new RatingsException(String.format("The vote [%s] is out of scale [%s] for [%s] rating manager.", vote, this.getScale(), this.getIdentifier()));
        }
    }

    private void checkIfDocumentExists(EntityReference reference) throws RatingsException {
        Optional optionalDoc = DocumentReference.extractDocument((EntityReference)reference);
        try {
            if (optionalDoc.isEmpty() || !this.documentAccessBridge.exists((DocumentReference)optionalDoc.get())) {
                throw new RatingsException(String.format("The reference [%s] is not an existing page.", reference));
            }
        }
        catch (Exception e) {
            if (e instanceof RatingsException) {
                throw (RatingsException)e;
            }
            throw new RatingsException(String.format("An error occurred while checking of [%s] exists", reference), e);
        }
    }
}

