/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.ratings.RatingsManager;
import org.xwiki.ratings.internal.migration.SolrDocumentMigration120900000;
import org.xwiki.search.solr.AbstractSolrCoreInitializer;
import org.xwiki.search.solr.SolrException;

@Component
@Singleton
@Named(value="ratings")
public class RatingSolrCoreInitializer
extends AbstractSolrCoreInitializer {
    public static final String DEFAULT_RATINGS_SOLR_CORE = "ratings";
    private static final long CURRENT_VERSION = 120900000L;
    @Inject
    private SolrDocumentMigration120900000 solrDocumentMigration120900000;

    protected void createSchema() throws SolrException {
        this.addStringField(RatingsManager.RatingQueryField.MANAGER_ID.getFieldName(), false, false);
        this.addStringField(RatingsManager.RatingQueryField.ENTITY_REFERENCE.getFieldName(), false, false);
        this.addStringField(RatingsManager.RatingQueryField.PARENTS_REFERENCE.getFieldName(), true, false);
        this.addStringField(RatingsManager.RatingQueryField.USER_REFERENCE.getFieldName(), false, false);
        this.addPIntField(RatingsManager.RatingQueryField.VOTE.getFieldName(), false, false);
        this.addPIntField(RatingsManager.RatingQueryField.SCALE.getFieldName(), false, false);
        this.addPDateField(RatingsManager.RatingQueryField.CREATED_DATE.getFieldName(), false, false);
        this.addPDateField(RatingsManager.RatingQueryField.UPDATED_DATE.getFieldName(), false, false);
    }

    protected void migrateSchema(long cversion) throws SolrException {
        if (cversion == 120700000L) {
            this.migrateFrom120700000();
        }
    }

    private void migrateFrom120700000() throws SolrException {
        this.logger.info("Starting migration of ratings solr core schema.");
        this.addStringField(RatingsManager.RatingQueryField.MANAGER_ID.getFieldName(), false, false);
        this.addStringField(RatingsManager.RatingQueryField.ENTITY_REFERENCE.getFieldName(), false, false);
        this.addStringField(RatingsManager.RatingQueryField.PARENTS_REFERENCE.getFieldName(), true, false);
        this.addPIntField(RatingsManager.RatingQueryField.SCALE.getFieldName(), false, false);
        this.addPDateField(RatingsManager.RatingQueryField.CREATED_DATE.getFieldName(), false, false);
        this.addPDateField(RatingsManager.RatingQueryField.UPDATED_DATE.getFieldName(), false, false);
        this.logger.info("Ratings Solr Core schema migrated. Starting migration of already existing ratings.");
        int scaleUpperBound = 5;
        this.solrDocumentMigration120900000.migrateAllDocumentsFrom1207000000(this.core, scaleUpperBound, DEFAULT_RATINGS_SOLR_CORE);
        this.deleteField("date", false);
        this.deleteField("parent", false);
        this.deleteField("ratingId", false);
        this.commit();
        this.logger.info("Ratings Solr Core migration finished.");
    }

    protected long getVersion() {
        return 120900000L;
    }

    protected int getMigrationBatchRows() {
        return 10000;
    }
}

