/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.event.AbstractLocalEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.ratings.RatingsException;
import org.xwiki.ratings.RatingsManager;
import org.xwiki.ratings.RatingsManagerFactory;
import org.xwiki.refactoring.event.DocumentRenamedEvent;

@Component
@Singleton
@Named(value="RatingMovedEntityListener")
public class RatingMovedEntityListener
extends AbstractLocalEventListener {
    static final String NAME = "RatingMovedEntityListener";
    @Inject
    private Logger logger;
    @Inject
    private RatingsManagerFactory ratingsManagerFactory;

    public RatingMovedEntityListener() {
        super(NAME, new Event[]{new DocumentRenamedEvent()});
    }

    public void processLocalEvent(Event event, Object source, Object data) {
        DocumentRenamedEvent renamedEvent = (DocumentRenamedEvent)event;
        DocumentReference oldReference = (DocumentReference)renamedEvent.getSourceReference();
        DocumentReference newReference = (DocumentReference)renamedEvent.getTargetReference();
        try {
            for (RatingsManager manager : this.ratingsManagerFactory.getInstantiatedManagers()) {
                manager.moveRatings((EntityReference)oldReference, (EntityReference)newReference);
            }
        }
        catch (RatingsException e) {
            this.logger.error("Error while updating ratings related to old reference [{}] from ratings: [{}]", (Object)oldReference, (Object)ExceptionUtils.getRootCause((Throwable)e));
        }
    }
}

