/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.XObjectDeletedEvent;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.ObservationContext;
import org.xwiki.observation.event.BeginEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.ratings.RatingsException;
import org.xwiki.ratings.RatingsManager;
import org.xwiki.ratings.RatingsManagerFactory;
import org.xwiki.refactoring.event.DocumentRenamingEvent;

@Component
@Singleton
@Named(value="RatingDeletedEntityListener")
public class RatingDeletedEntityListener
extends AbstractEventListener {
    static final String NAME = "RatingDeletedEntityListener";
    private static final List<Event> EVENT_LIST = Arrays.asList(new XObjectDeletedEvent(), new DocumentDeletedEvent(), new WikiDeletedEvent());
    private static final DocumentRenamingEvent RENAMING_EVENT = new DocumentRenamingEvent();
    @Inject
    private Logger logger;
    @Inject
    private RatingsManagerFactory ratingsManagerFactory;
    @Inject
    private ObservationContext observationContext;

    public RatingDeletedEntityListener() {
        super(NAME, EVENT_LIST);
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof DocumentDeletedEvent && !this.observationContext.isIn((BeginEvent)RENAMING_EVENT)) {
            XWikiDocument sourceDoc = (XWikiDocument)source;
            this.handleDeletedReference((EntityReference)sourceDoc.getDocumentReference());
        } else if (event instanceof XObjectDeletedEvent) {
            XObjectDeletedEvent xObjectDeletedEvent = (XObjectDeletedEvent)event;
            this.handleDeletedReference(xObjectDeletedEvent.getReference());
        } else if (event instanceof WikiDeletedEvent) {
            WikiDeletedEvent wikiDeletedEvent = (WikiDeletedEvent)event;
            this.handleDeletedReference((EntityReference)new WikiReference(wikiDeletedEvent.getWikiId()));
        }
    }

    private void handleDeletedReference(EntityReference deletedReference) {
        try {
            for (RatingsManager manager : this.ratingsManagerFactory.getInstantiatedManagers()) {
                manager.removeRatings(deletedReference);
            }
        }
        catch (RatingsException e) {
            this.logger.error("Error while removing ratings related to reference [{}] from ratings: [{}]", (Object)deletedReference, (Object)ExceptionUtils.getRootCause((Throwable)e));
        }
    }
}

