/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ratings.internal;

import java.util.Date;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.ratings.Rating;
import org.xwiki.text.XWikiToStringBuilder;
import org.xwiki.user.UserReference;

public class DefaultRating
implements Rating {
    private String identifier;
    private String managerId;
    private EntityReference reference;
    private UserReference user;
    private Date createdAt;
    private Date updatedAt;
    private int vote;
    private int scale;

    public DefaultRating(String identifier) {
        this.identifier = identifier;
        this.createdAt = new Date();
        this.updatedAt = new Date();
    }

    public DefaultRating(Rating rating) {
        this.identifier = rating.getId();
        this.managerId = rating.getManagerId();
        this.reference = rating.getReference();
        this.vote = rating.getVote();
        this.updatedAt = rating.getUpdatedAt();
        this.createdAt = rating.getCreatedAt();
        this.scale = rating.getScaleUpperBound();
        this.user = rating.getAuthor();
    }

    @Override
    public String getId() {
        return this.identifier;
    }

    @Override
    public String getManagerId() {
        return this.managerId;
    }

    @Override
    public EntityReference getReference() {
        return this.reference;
    }

    @Override
    public UserReference getAuthor() {
        return this.user;
    }

    @Override
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public DefaultRating setUpdatedAt(Date date) {
        this.updatedAt = date;
        return this;
    }

    @Override
    public int getVote() {
        return this.vote;
    }

    public DefaultRating setId(String id) {
        this.identifier = id;
        return this;
    }

    public DefaultRating setVote(int vote) {
        this.vote = vote;
        return this;
    }

    public DefaultRating setManagerId(String managerId) {
        this.managerId = managerId;
        return this;
    }

    public DefaultRating setReference(EntityReference reference) {
        this.reference = reference;
        return this;
    }

    public DefaultRating setAuthor(UserReference user) {
        this.user = user;
        return this;
    }

    public DefaultRating setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    public DefaultRating setScaleUpperBound(int scale) {
        this.scale = scale;
        return this;
    }

    @Override
    public int getScaleUpperBound() {
        return this.scale;
    }

    public String toString() {
        return new XWikiToStringBuilder((Object)this).append("identifier", (Object)this.identifier).append("managerId", (Object)this.managerId).append("reference", (Object)this.reference).append("user", (Object)this.user).append("createdAt", (Object)this.createdAt).append("updatedAt", (Object)this.updatedAt).append("vote", this.vote).append("scale", this.scale).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultRating that = (DefaultRating)o;
        return new EqualsBuilder().append(this.vote, that.vote).append(this.scale, that.scale).append((Object)this.identifier, (Object)that.identifier).append((Object)this.managerId, (Object)that.managerId).append((Object)this.reference, (Object)that.reference).append((Object)this.user, (Object)that.user).append((Object)this.createdAt, (Object)that.createdAt).append((Object)this.updatedAt, (Object)that.updatedAt).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(13, 97).append((Object)this.identifier).append((Object)this.managerId).append((Object)this.reference).append((Object)this.user).append((Object)this.createdAt).append((Object)this.updatedAt).append(this.vote).append(this.scale).toHashCode();
    }
}

