/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.query.xwql.internal.hql;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.query.internal.jpql.node.Start;
import org.xwiki.query.internal.jpql.node.Switch;
import org.xwiki.query.jpql.internal.JPQLParser;
import org.xwiki.query.xwql.internal.QueryAnalyzer;
import org.xwiki.query.xwql.internal.QueryContext;
import org.xwiki.query.xwql.internal.QueryTranslator;
import org.xwiki.query.xwql.internal.hql.Printer;

@Component
@Named(value="hql")
@Singleton
public class XWQLtoHQLTranslator
implements QueryTranslator {
    @Inject
    protected DocumentAccessBridge documentAccessBridge;

    @Override
    public String translate(String input) throws Exception {
        input = ((String)input).trim();
        String lcInput = ((String)input).toLowerCase();
        String addition = "select doc.fullName from Document as doc ";
        if (lcInput.startsWith("where") || lcInput.startsWith("order") || lcInput.length() == 0) {
            input = addition + (String)input;
        } else if (lcInput.startsWith("from")) {
            input = addition + "," + ((String)input).substring(4);
        }
        JPQLParser parser = new JPQLParser();
        Start tree = parser.parse((String)input);
        QueryContext context = new QueryContext(tree, this.getDocumentAccessBridge());
        tree.apply((Switch)new QueryAnalyzer(context));
        Printer printer = this.getPrinter(context);
        return printer.print();
    }

    @Override
    public String getOutputLanguage() {
        return "hql";
    }

    protected Printer getPrinter(QueryContext context) {
        return new Printer(context, this);
    }

    public DocumentAccessBridge getDocumentAccessBridge() {
        return this.documentAccessBridge;
    }
}

