/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.macro.office;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.AttachmentReference;
import org.xwiki.model.reference.AttachmentReferenceResolver;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.office.viewer.OfficeResourceViewer;
import org.xwiki.officeimporter.server.OfficeServer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.listener.reference.AttachmentResourceReference;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.listener.reference.ResourceType;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.office.OfficeMacroParameters;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="office")
@Singleton
public class OfficeMacro
extends AbstractMacro<OfficeMacroParameters> {
    @Inject
    private OfficeResourceViewer officeViewer;
    @Inject
    private OfficeServer officeServer;
    @Inject
    @Named(value="macro")
    private AttachmentReferenceResolver<String> macroAttachmentReferenceResolver;
    @Inject
    @Named(value="macro")
    private DocumentReferenceResolver<String> macroDocumentReferenceResolver;
    @Inject
    private EntityReferenceSerializer<String> serializer;

    public OfficeMacro() {
        super("Office Document Viewer", "View office attachments (doc, ppt, xls, odt, odp, ods etc.) inside wiki pages without downloading or importing them.", OfficeMacroParameters.class);
        this.setDefaultCategories(Set.of("Content"));
    }

    public List<Block> execute(OfficeMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        if (!this.officeServer.getState().equals((Object)OfficeServer.ServerState.CONNECTED)) {
            throw new MacroExecutionException("The wiki needs to be connected to an office server in order to view office files. Ask your administrator to configure such a server.");
        }
        ResourceReference resourceReference = this.getResourceReference(context.getCurrentMacroBlock(), parameters);
        HashMap<String, Boolean> viewParameters = new HashMap<String, Boolean>();
        viewParameters.put("filterStyles", parameters.isFilterStyles());
        viewParameters.put("ownerDocument", (Boolean)this.getOwnerDocument(context.getCurrentMacroBlock()));
        try {
            return this.officeViewer.createView(resourceReference, viewParameters).getChildren();
        }
        catch (Exception e) {
            throw new MacroExecutionException("Failed to view office attachment.", (Throwable)e);
        }
    }

    public boolean supportsInlineMode() {
        return false;
    }

    private DocumentReference getOwnerDocument(MacroBlock block) {
        return this.macroDocumentReferenceResolver.resolve((Object)"", new Object[]{block});
    }

    private ResourceReference getResourceReference(MacroBlock block, OfficeMacroParameters parameters) throws MacroExecutionException {
        ResourceReference resourceReference = parameters.getReference();
        if (resourceReference == null || resourceReference.getType().equals((Object)ResourceType.ATTACHMENT) || !resourceReference.isTyped()) {
            AttachmentReference attachmentReference;
            if (resourceReference == null) {
                String reference = parameters.getAttachment();
                if (StringUtils.isEmpty((CharSequence)reference)) {
                    throw new MacroExecutionException("You must specify the 'reference' parameter pointing to the office file to display.");
                }
                attachmentReference = this.macroAttachmentReferenceResolver.resolve((Object)reference, new Object[]{block});
            } else {
                attachmentReference = this.macroAttachmentReferenceResolver.resolve((Object)resourceReference.getReference(), new Object[]{block});
            }
            resourceReference = new AttachmentResourceReference((String)this.serializer.serialize((EntityReference)attachmentReference, new Object[0]));
        }
        return resourceReference;
    }

    public boolean isExecutionIsolated(OfficeMacroParameters parameters, String content) {
        return true;
    }
}

