/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.observation.remote.internal.jgroups;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.jgroups.BytesMessage;
import org.jgroups.Message;
import org.jgroups.blocks.cs.ReceiverAdapter;
import org.slf4j.Logger;
import org.xwiki.classloader.ClassLoaderManager;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.observation.remote.RemoteEventData;
import org.xwiki.observation.remote.RemoteObservationManager;
import org.xwiki.observation.remote.jgroups.JGroupsReceiver;

@Component
@Singleton
public class DefaultJGroupsReceiver
extends ReceiverAdapter
implements JGroupsReceiver {
    private RemoteObservationManager remoteObservationManager;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private ClassLoaderManager classLoaderManager;
    @Inject
    private Logger logger;

    public RemoteObservationManager getRemoteObservationManager() {
        if (this.remoteObservationManager == null) {
            try {
                this.remoteObservationManager = (RemoteObservationManager)this.componentManager.getInstance(RemoteObservationManager.class);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Failed to lookup the Remote Observation Manager.", (Throwable)e);
            }
        }
        return this.remoteObservationManager;
    }

    public void receive(Message msg) {
        if (msg instanceof BytesMessage) {
            RemoteEventData remoteEvent = (RemoteEventData)((BytesMessage)msg).getObject((ClassLoader)this.classLoaderManager.getURLClassLoader(null, false));
            this.logger.debug("Received JGroups remote event [{}]", (Object)remoteEvent);
            this.getRemoteObservationManager().notify(remoteEvent);
        }
    }
}

