/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.sources.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.internal.DefaultNotificationFilterPreference;
import org.xwiki.notifications.sources.NotificationParameters;
import org.xwiki.notifications.sources.internal.FollowedUserOnlyEventFilter;

@Component(roles={UsersParameterHandler.class})
@Singleton
public class UsersParameterHandler {
    private static final String FIELD_SEPARATOR = ",";
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentDocumentReferenceResolver;
    @Inject
    private DocumentReferenceResolver<String> defaultDocumentReferenceResolver;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;

    public void handleUsersParameter(String users, NotificationParameters parameters) throws Exception {
        if (StringUtils.isNotBlank((CharSequence)users)) {
            String[] userArray = users.split(FIELD_SEPARATOR);
            ArrayList<String> userList = new ArrayList<String>();
            for (int i = 0; i < userArray.length; ++i) {
                DocumentReference userReference;
                Object user = userArray[i].trim();
                if (!((String)user).contains(".")) {
                    user = "XWiki." + (String)user;
                }
                if (this.documentAccessBridge.exists(userReference = this.currentDocumentReferenceResolver.resolve(user, new Object[0]))) {
                    userList.add((String)this.entityReferenceSerializer.serialize((EntityReference)userReference, new Object[0]));
                    continue;
                }
                userList.add((String)this.entityReferenceSerializer.serialize((EntityReference)this.defaultDocumentReferenceResolver.resolve(user, new Object[0]), new Object[0]));
            }
            parameters.filters.add(new FollowedUserOnlyEventFilter(this.entityReferenceSerializer, userList));
            this.addFilterPreference(parameters, userList);
        }
    }

    private void addFilterPreference(NotificationParameters parameters, List<String> userList) {
        HashSet<NotificationFormat> formats = new HashSet<NotificationFormat>();
        formats.add(parameters.format);
        for (String userId : userList) {
            DefaultNotificationFilterPreference pref = new DefaultNotificationFilterPreference();
            pref.setId(String.format("userRestFilters_%s", userId));
            pref.setFilterType(NotificationFilterType.INCLUSIVE);
            pref.setEnabled(true);
            pref.setNotificationFormats(formats);
            pref.setUser(userId);
            parameters.filterPreferences.add((NotificationFilterPreference)pref);
        }
    }
}

