/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.sources.internal;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.eventstream.RecordableEventDescriptor;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.preferences.NotificationPreference;
import org.xwiki.notifications.preferences.NotificationPreferenceCategory;
import org.xwiki.notifications.preferences.NotificationPreferenceProperty;

public class InternalNotificationPreference
implements NotificationPreference {
    private RecordableEventDescriptor descriptor;

    public InternalNotificationPreference(RecordableEventDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public boolean isNotificationEnabled() {
        return true;
    }

    public NotificationFormat getFormat() {
        return NotificationFormat.ALERT;
    }

    public Date getStartDate() {
        return new Date(0L);
    }

    public Map<NotificationPreferenceProperty, Object> getProperties() {
        HashMap<NotificationPreferenceProperty, Object> properties = new HashMap<NotificationPreferenceProperty, Object>();
        properties.put(NotificationPreferenceProperty.EVENT_TYPE, this.descriptor.getEventType());
        return properties;
    }

    public String getProviderHint() {
        return "factory";
    }

    public NotificationPreferenceCategory getCategory() {
        return NotificationPreferenceCategory.DEFAULT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalNotificationPreference that = (InternalNotificationPreference)o;
        return new EqualsBuilder().append((Object)this.descriptor, (Object)that.descriptor).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.descriptor).toHashCode();
    }
}

