/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.sources.internal;

import java.util.Collection;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.eventstream.Event;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.expression.EventProperty;
import org.xwiki.notifications.filters.expression.ExpressionNode;
import org.xwiki.notifications.filters.expression.generics.ExpressionBuilder;
import org.xwiki.notifications.preferences.NotificationPreference;

public class FollowedUserOnlyEventFilter
implements NotificationFilter {
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    private Collection<String> followedUsers;

    public FollowedUserOnlyEventFilter(EntityReferenceSerializer<String> entityReferenceSerializer, Collection<String> followedUsers) {
        this.entityReferenceSerializer = entityReferenceSerializer;
        this.followedUsers = followedUsers;
    }

    public NotificationFilter.FilterPolicy filterEvent(Event event, DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFormat format) {
        return this.followedUsers.contains(this.entityReferenceSerializer.serialize((EntityReference)event.getUser(), new Object[0])) ? NotificationFilter.FilterPolicy.NO_EFFECT : NotificationFilter.FilterPolicy.FILTER;
    }

    public boolean matchesPreference(NotificationPreference preference) {
        return false;
    }

    public ExpressionNode filterExpression(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationPreference preference) {
        return null;
    }

    public ExpressionNode filterExpression(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFilterType type, NotificationFormat format) {
        if (type == NotificationFilterType.EXCLUSIVE) {
            return ExpressionBuilder.value((EventProperty)EventProperty.USER).inStrings(this.followedUsers);
        }
        return null;
    }

    public String getName() {
        return "FollowedUserOnlyEventFilter";
    }

    public int getPriority() {
        return 3000;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FollowedUserOnlyEventFilter that = (FollowedUserOnlyEventFilter)o;
        return new EqualsBuilder().append(this.entityReferenceSerializer, that.entityReferenceSerializer).append(this.followedUsers, that.followedUsers).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.entityReferenceSerializer).append(this.followedUsers).toHashCode();
    }
}

