/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.sources.internal;

import java.util.ArrayList;
import java.util.EnumMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.query.SimpleEventQuery;
import org.xwiki.eventstream.query.SortableEventQuery;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.expression.AndNode;
import org.xwiki.notifications.filters.expression.ConcatNode;
import org.xwiki.notifications.filters.expression.EndsWith;
import org.xwiki.notifications.filters.expression.EqualsNode;
import org.xwiki.notifications.filters.expression.EventProperty;
import org.xwiki.notifications.filters.expression.ExpressionNode;
import org.xwiki.notifications.filters.expression.GreaterThanNode;
import org.xwiki.notifications.filters.expression.InNode;
import org.xwiki.notifications.filters.expression.InSubQueryNode;
import org.xwiki.notifications.filters.expression.LesserThanNode;
import org.xwiki.notifications.filters.expression.NotEqualsNode;
import org.xwiki.notifications.filters.expression.NotNode;
import org.xwiki.notifications.filters.expression.OrNode;
import org.xwiki.notifications.filters.expression.PropertyValueNode;
import org.xwiki.notifications.filters.expression.StartsWith;
import org.xwiki.notifications.filters.expression.generics.AbstractBinaryOperatorNode;
import org.xwiki.notifications.filters.expression.generics.AbstractOperatorNode;
import org.xwiki.notifications.filters.expression.generics.AbstractUnaryOperatorNode;
import org.xwiki.notifications.filters.expression.generics.AbstractValueNode;
import org.xwiki.notifications.filters.internal.status.ForUserNode;
import org.xwiki.notifications.sources.internal.OrderByNode;

@Component(roles={ExpressionNodeToEventQueryConverter.class})
@Singleton
public class ExpressionNodeToEventQueryConverter {
    private static final String FORMAT_UNSUPPORTED_OPERATOR = "Unsupported operator [%s]";
    private static final EnumMap<EventProperty, String> PROPERTY_MAPPING = new EnumMap(EventProperty.class);
    @Inject
    private EntityReferenceSerializer<String> serializer;

    public SimpleEventQuery parse(ExpressionNode node) throws EventStreamException {
        SimpleEventQuery result = new SimpleEventQuery();
        this.parseBlock(node, result, false);
        return result;
    }

    private void parseBlock(ExpressionNode node, SimpleEventQuery result, boolean ingroup) throws EventStreamException {
        if (node instanceof AbstractUnaryOperatorNode) {
            this.parseUnaryOperator((AbstractUnaryOperatorNode)node, result, ingroup);
        } else if (node instanceof AbstractBinaryOperatorNode) {
            this.parseBinaryOperator((AbstractBinaryOperatorNode)node, result, ingroup);
        } else if (node instanceof AbstractOperatorNode) {
            this.parseOtherOperation((AbstractOperatorNode)node, result, ingroup);
        } else {
            throw new EventStreamException(String.format("Unsupported block node [%s]", node));
        }
    }

    private String getProperty(AbstractBinaryOperatorNode operator) throws EventStreamException {
        if (operator.getLeftOperand() instanceof PropertyValueNode) {
            return this.getProperty((PropertyValueNode)operator.getLeftOperand());
        }
        if (operator.getRightOperand() instanceof PropertyValueNode) {
            return this.getProperty((PropertyValueNode)operator.getRightOperand());
        }
        throw new EventStreamException(String.format(FORMAT_UNSUPPORTED_OPERATOR, operator));
    }

    private Object getValue(AbstractBinaryOperatorNode operator) throws EventStreamException {
        if (operator.getLeftOperand() instanceof PropertyValueNode) {
            return this.getValue((AbstractValueNode)operator.getRightOperand());
        }
        if (operator.getRightOperand() instanceof PropertyValueNode) {
            return this.getValue((AbstractValueNode)operator.getLeftOperand());
        }
        throw new EventStreamException(String.format(FORMAT_UNSUPPORTED_OPERATOR, operator));
    }

    private String getProperty(PropertyValueNode propertyNode) throws EventStreamException {
        String property = PROPERTY_MAPPING.get(propertyNode.getContent());
        if (property == null) {
            throw new EventStreamException(String.format("Unsupported property node [%s]", propertyNode));
        }
        return property;
    }

    private Object getValue(AbstractValueNode value) throws EventStreamException {
        if (value instanceof ConcatNode) {
            throw new EventStreamException(String.format("Unsupported value node [%s]", value));
        }
        return value.getContent();
    }

    private SimpleEventQuery parseUnaryOperator(AbstractUnaryOperatorNode operator, SimpleEventQuery result, boolean ingroup) throws EventStreamException {
        if (operator instanceof NotNode) {
            result.not();
            this.parseBlock((ExpressionNode)operator.getOperand(), result, true);
        }
        return result;
    }

    private void parseEqualsNode(AbstractBinaryOperatorNode operator, SimpleEventQuery result) throws EventStreamException {
        if (operator.getLeftOperand() instanceof PropertyValueNode) {
            result.eq(this.getProperty((PropertyValueNode)operator.getLeftOperand()), this.getValue((AbstractValueNode)operator.getRightOperand()));
        } else if (operator.getRightOperand() instanceof PropertyValueNode) {
            result.eq(this.getProperty((PropertyValueNode)operator.getRightOperand()), this.getValue((AbstractValueNode)operator.getLeftOperand()));
        } else if (!operator.getLeftOperand().equals(operator.getRightOperand())) {
            throw new EventStreamException(String.format(FORMAT_UNSUPPORTED_OPERATOR, operator));
        }
    }

    private void parseBinaryOperator(AbstractBinaryOperatorNode operator, SimpleEventQuery result, boolean ingroup) throws EventStreamException {
        if (operator instanceof AndNode) {
            if (ingroup) {
                result.open();
            }
            this.parseBlock((ExpressionNode)operator.getLeftOperand(), result, ingroup);
            this.parseBlock((ExpressionNode)operator.getRightOperand(), result, ingroup);
            if (ingroup) {
                result.close();
            }
        } else if (operator instanceof OrNode) {
            result.open();
            this.parseBlock((ExpressionNode)operator.getLeftOperand(), result, true);
            result.or();
            this.parseBlock((ExpressionNode)operator.getRightOperand(), result, true);
            result.close();
        } else if (operator instanceof EqualsNode) {
            this.parseEqualsNode(operator, result);
        } else if (operator instanceof NotEqualsNode) {
            result.not();
            this.parseEqualsNode(operator, result);
        } else if (operator instanceof StartsWith) {
            result.startsWith(this.getProperty(operator), this.getValue(operator));
        } else if (operator instanceof EndsWith) {
            result.endsWith(this.getProperty(operator), this.getValue(operator));
        } else if (operator instanceof GreaterThanNode) {
            GreaterThanNode greater = (GreaterThanNode)operator;
            if (greater.isOrEquals()) {
                result.greaterOrEq(this.getProperty(operator), this.getValue(operator));
            } else {
                result.greater(this.getProperty(operator), this.getValue(operator));
            }
        } else if (operator instanceof LesserThanNode) {
            LesserThanNode lesser = (LesserThanNode)operator;
            if (lesser.isOrEquals()) {
                result.lessOrEq(this.getProperty(operator), this.getValue(operator));
            } else {
                result.less(this.getProperty(operator), this.getValue(operator));
            }
        } else {
            throw new EventStreamException(String.format(FORMAT_UNSUPPORTED_OPERATOR, operator));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseOtherOperation(AbstractOperatorNode operator, SimpleEventQuery result, boolean ingroup) throws EventStreamException {
        if (operator instanceof InNode) {
            InNode inNode = (InNode)operator;
            if (!(inNode.getLeftOperand() instanceof PropertyValueNode)) throw new EventStreamException(String.format(FORMAT_UNSUPPORTED_OPERATOR, operator));
            ArrayList<Object> values = new ArrayList<Object>(inNode.getValues().size());
            for (AbstractValueNode valueNode : inNode.getValues()) {
                values.add(this.getValue(valueNode));
            }
            result.in(this.getProperty((PropertyValueNode)inNode.getLeftOperand()), values);
            return;
        } else {
            if (operator instanceof InSubQueryNode) {
                throw new EventStreamException(String.format(FORMAT_UNSUPPORTED_OPERATOR, operator));
            }
            if (operator instanceof OrderByNode) {
                OrderByNode order = (OrderByNode)operator;
                this.parseBlock((ExpressionNode)order.getQuery(), result, ingroup);
                result.addSort(this.getProperty(order.getProperty()), order.getOrder() == OrderByNode.Order.ASC ? SortableEventQuery.SortClause.Order.ASC : SortableEventQuery.SortClause.Order.DESC);
                return;
            } else {
                if (!(operator instanceof ForUserNode)) throw new EventStreamException(String.format(FORMAT_UNSUPPORTED_OPERATOR, operator));
                ForUserNode forUser = (ForUserNode)operator;
                if (forUser.getFormat() == NotificationFormat.ALERT) {
                    if (forUser.getUser() != null && forUser.isRead() != null) {
                        result.withStatus((String)this.serializer.serialize((EntityReference)forUser.getUser(), new Object[0]), forUser.isRead().booleanValue());
                        return;
                    } else if (forUser.getUser() != null) {
                        result.withStatus((String)this.serializer.serialize((EntityReference)forUser.getUser(), new Object[0]));
                        return;
                    } else {
                        if (forUser.isRead() == null) return;
                        result.withStatus(forUser.isRead().booleanValue());
                    }
                    return;
                } else {
                    if (forUser.getFormat() != NotificationFormat.EMAIL) return;
                    if (forUser.getUser() != null) {
                        result.open();
                        String entity = (String)this.serializer.serialize((EntityReference)forUser.getUser(), new Object[0]);
                        result.withMail(entity);
                        if (forUser.isRead() != null) {
                            result.withStatus(entity, forUser.isRead().booleanValue());
                        }
                        result.close();
                        return;
                    } else {
                        if (forUser.isRead() == null) return;
                        result.withStatus(forUser.isRead().booleanValue());
                    }
                }
            }
        }
    }

    static {
        PROPERTY_MAPPING.put(EventProperty.ID, "id");
        PROPERTY_MAPPING.put(EventProperty.GROUP_ID, "groupId");
        PROPERTY_MAPPING.put(EventProperty.STREAM, "stream");
        PROPERTY_MAPPING.put(EventProperty.DATE, "date");
        PROPERTY_MAPPING.put(EventProperty.REMOTE_OBSERVATION_ID, "observationInstanceId");
        PROPERTY_MAPPING.put(EventProperty.IMPORTANCE, "importance");
        PROPERTY_MAPPING.put(EventProperty.TYPE, "type");
        PROPERTY_MAPPING.put(EventProperty.APPLICATION, "application");
        PROPERTY_MAPPING.put(EventProperty.USER, "user");
        PROPERTY_MAPPING.put(EventProperty.WIKI, "wiki");
        PROPERTY_MAPPING.put(EventProperty.SPACE, "space");
        PROPERTY_MAPPING.put(EventProperty.PAGE, "document");
        PROPERTY_MAPPING.put(EventProperty.HIDDEN, "hidden");
        PROPERTY_MAPPING.put(EventProperty.URL, "url");
        PROPERTY_MAPPING.put(EventProperty.TITLE, "title");
        PROPERTY_MAPPING.put(EventProperty.BODY, "body");
        PROPERTY_MAPPING.put(EventProperty.DOCUMENT_VERSION, "documentVersion");
    }
}

