/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.sources.internal;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventQuery;
import org.xwiki.eventstream.EventSearchResult;
import org.xwiki.eventstream.EventStore;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.internal.EventStreamConfiguration;
import org.xwiki.eventstream.query.SimpleEventQuery;
import org.xwiki.notifications.sources.NotificationParameters;
import org.xwiki.notifications.sources.internal.EventQueryGenerator;
import org.xwiki.query.QueryException;

@Component(roles={EventSearcher.class})
@Singleton
public class EventSearcher {
    @Inject
    protected EventStore eventStore;
    @Inject
    protected EventQueryGenerator eventQueryGenerator;
    @Inject
    protected EventStreamConfiguration configuration;
    @Inject
    protected Logger logger;

    public List<Event> searchEvents(int offset, int limit, NotificationParameters parameters) throws QueryException, EventStreamException {
        if (this.configuration.isEventStoreEnabled()) {
            return this.searchStoreEvents(offset, limit, parameters);
        }
        return Collections.emptyList();
    }

    public List<Event> searchStoreEvents(int offset, int limit, NotificationParameters parameters) throws EventStreamException {
        List<Event> list;
        block8: {
            SimpleEventQuery query = this.eventQueryGenerator.generateQuery(parameters);
            query.setLimit((long)limit).setOffset((long)offset);
            EventSearchResult result = this.eventStore.search((EventQuery)query);
            try {
                list = result.stream().collect(Collectors.toList());
                if (result == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new EventStreamException("Failed to close the event search result", (Throwable)e);
                }
            }
            result.close();
        }
        return list;
    }
}

