/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.sources.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.GroupingEventManager;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.sources.NotificationParameters;
import org.xwiki.notifications.sources.ParametrizedNotificationManager;
import org.xwiki.notifications.sources.internal.EventSearcher;
import org.xwiki.notifications.sources.internal.PreferenceDateNotificationFilter;
import org.xwiki.notifications.sources.internal.RecordableEventDescriptorHelper;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;
import org.xwiki.user.group.GroupException;
import org.xwiki.user.group.GroupManager;

@Component
@Singleton
public class DefaultParametrizedNotificationManager
implements ParametrizedNotificationManager {
    private static final int MAX_BATCH_SIZE = 1280;
    @Inject
    private EventSearcher eventSearcher;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private ContextualAuthorizationManager contextualAuthorizationManager;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private GroupManager groupManager;
    @Inject
    @Named(value="eventReadAlertFilter")
    private NotificationFilter eventReadAlertFilter;
    @Inject
    @Named(value="eventReadEmailFilter")
    private NotificationFilter eventReadEmailFilter;
    @Inject
    private RecordableEventDescriptorHelper recordableEventDescriptorHelper;
    @Inject
    private PreferenceDateNotificationFilter preferenceDateNotificationFilter;
    @Inject
    private GroupingEventManager groupingEventManager;
    @Inject
    private Logger logger;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> userReferenceResolver;

    @Override
    public List<CompositeEvent> getEvents(NotificationParameters parameters) throws NotificationException {
        ArrayList<CompositeEvent> compositeEvents = new ArrayList<CompositeEvent>();
        this.getRawEvents(parameters, compositeEvents);
        return compositeEvents;
    }

    @Override
    public List<Event> getRawEvents(NotificationParameters parameters) throws NotificationException {
        return this.getRawEvents(parameters, null);
    }

    private List<Event> getRawEvents(NotificationParameters parameters, List<CompositeEvent> compositeEvents) throws NotificationException {
        if (Boolean.TRUE.equals(parameters.onlyUnread) && !parameters.filters.contains(this.eventReadAlertFilter)) {
            parameters.filters.add(this.eventReadAlertFilter);
        }
        if (Boolean.TRUE.equals(parameters.onlyUnread) && !parameters.filters.contains(this.eventReadEmailFilter)) {
            parameters.filters.add(this.eventReadEmailFilter);
        }
        ArrayList<Event> results = new ArrayList<Event>();
        int batchSize = parameters.expectedCount * 2;
        int offset = 0;
        try {
            boolean done = false;
            while (!done) {
                List<Event> batch = this.eventSearcher.searchEvents(offset, batchSize, parameters);
                done = this.addMatchingEventsToResults(batch, parameters, results, compositeEvents);
                if (done) continue;
                if (batch.size() < batchSize) {
                    done = true;
                    continue;
                }
                offset += batchSize;
                if (batchSize >= 1280) continue;
                batchSize <<= 1;
            }
            return results;
        }
        catch (Exception e) {
            throw new NotificationException("Fail to get the list of notifications.", (Throwable)e);
        }
    }

    private boolean addMatchingEventsToResults(List<Event> batch, NotificationParameters parameters, List<Event> results, List<CompositeEvent> compositeEvents) throws EventStreamException, NotificationException {
        boolean done = false;
        for (Event event : batch) {
            DocumentReference document = event.getDocument();
            if (document != null && !this.isAllowed(parameters.user, document) || this.filterEvent(event, parameters)) continue;
            results.add(event);
            int reachedSize = results.size();
            if (compositeEvents != null) {
                UserReference userReference = null;
                if (parameters.user != null) {
                    userReference = this.userReferenceResolver.resolve((Object)parameters.user, new Object[0]);
                }
                this.groupingEventManager.augmentCompositeEvents(compositeEvents, List.of(event), userReference, parameters.groupingEventTarget);
                reachedSize = compositeEvents.size();
            }
            if (reachedSize < parameters.expectedCount) continue;
            done = true;
            break;
        }
        return done;
    }

    private boolean isAllowed(DocumentReference passedUser, DocumentReference document) {
        boolean allowed = this.authorizationManager.hasAccess(Right.VIEW, passedUser, (EntityReference)document);
        if (allowed) {
            allowed = this.contextualAuthorizationManager.hasAccess(Right.VIEW, (EntityReference)document);
        }
        return allowed;
    }

    private boolean eventTargetUser(Event event, DocumentReference userReference) {
        boolean result = false;
        if (event.getTarget() != null && !event.getTarget().isEmpty() && userReference != null) {
            String serializedUserReference = (String)this.serializer.serialize((EntityReference)userReference, new Object[0]);
            if (event.getTarget().contains(serializedUserReference)) {
                result = true;
            } else {
                try {
                    Collection groups = this.groupManager.getGroups(userReference, null, true);
                    for (DocumentReference group : groups) {
                        if (!event.getTarget().contains(this.serializer.serialize((EntityReference)group, new Object[0]))) continue;
                        result = true;
                        break;
                    }
                }
                catch (GroupException e) {
                    this.logger.error("Error while checking groups for user [{}]", (Object)userReference, (Object)e);
                }
            }
        }
        return result;
    }

    private boolean filterEvent(Event event, NotificationParameters parameters) throws EventStreamException {
        if (!(event.getTarget().isEmpty() || parameters.user != null && this.eventTargetUser(event, parameters.user))) {
            return true;
        }
        if (!this.recordableEventDescriptorHelper.hasDescriptor(event.getType(), parameters.user) || this.preferenceDateNotificationFilter.shouldFilter(event, parameters.preferences)) {
            return true;
        }
        ArrayList<NotificationFilter> filters = new ArrayList<NotificationFilter>(parameters.filters);
        Collections.sort(filters);
        for (NotificationFilter filter : filters) {
            NotificationFilter.FilterPolicy policy = filter.filterEvent(event, parameters.user, parameters.filterPreferences, parameters.format);
            switch (policy) {
                case FILTER: {
                    return true;
                }
                case KEEP: {
                    return false;
                }
            }
        }
        return false;
    }
}

