/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.script.internal;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.eventstream.EventStatus;
import org.xwiki.eventstream.EventStore;
import org.xwiki.eventstream.internal.DefaultEvent;
import org.xwiki.eventstream.internal.DefaultEventStatus;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.CompositeEventStatus;
import org.xwiki.notifications.CompositeEventStatusManager;

@Component(roles={NotificationScriptEventHelper.class})
@Singleton
public class NotificationScriptEventHelper {
    @Inject
    private EventStore eventStore;
    @Inject
    private CompositeEventStatusManager compositeEventStatusManager;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private DocumentAccessBridge documentAccessBridge;

    public List<EventStatus> getEventStatuses(List<Event> events) throws Exception {
        return this.eventStore.getEventStatuses(events, Arrays.asList((String)this.entityReferenceSerializer.serialize((EntityReference)this.documentAccessBridge.getCurrentUserReference(), new Object[0])));
    }

    public List<CompositeEventStatus> getCompositeEventStatuses(List<CompositeEvent> compositeEvents) throws Exception {
        return this.compositeEventStatusManager.getCompositeEventStatuses(compositeEvents, (String)this.entityReferenceSerializer.serialize((EntityReference)this.documentAccessBridge.getCurrentUserReference(), new Object[0]));
    }

    public void saveEventStatus(String eventId, boolean isRead) throws Exception {
        DefaultEvent event = new DefaultEvent();
        event.setId(eventId);
        String userId = (String)this.entityReferenceSerializer.serialize((EntityReference)this.documentAccessBridge.getCurrentUserReference(), new Object[0]);
        this.eventStore.saveEventStatus((EventStatus)new DefaultEventStatus((Event)event, userId, isRead));
    }

    public void clearAllStatus(Date startDate) throws Exception {
        String userId = (String)this.entityReferenceSerializer.serialize((EntityReference)this.documentAccessBridge.getCurrentUserReference(), new Object[0]);
        this.eventStore.deleteEventStatuses(userId, startDate);
    }
}

