/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.rest.internal;

import com.rometools.rome.io.FeedException;
import com.rometools.rome.io.SyndFeedOutput;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.rss.NotificationRSSManager;

@Component(roles={RSSFeedRenderer.class})
@Singleton
public class RSSFeedRenderer {
    @Inject
    private NotificationRSSManager notificationRSSManager;

    public String render(List<CompositeEvent> eventList) throws NotificationException {
        SyndFeedOutput output = new SyndFeedOutput();
        try {
            return output.outputString(this.notificationRSSManager.renderFeed(eventList));
        }
        catch (FeedException e) {
            throw new NotificationException("Error while rendering the RSS feed of events", (Throwable)e);
        }
    }
}

