/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.rest.internal;

import com.xpn.xwiki.XWikiContext;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.notifications.NotificationConfiguration;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.internal.DefaultNotificationCacheManager;

@Component(roles={NotificationEventExecutor.class})
@Singleton
public class NotificationEventExecutor
implements Initializable,
Disposable {
    @Inject
    private NotificationConfiguration notificationConfiguration;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private ExecutionContextManager contextManager;
    @Inject
    private Execution execution;
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private DefaultNotificationCacheManager notificationCacheManager;
    private final AtomicLong counter = new AtomicLong();
    private final ConcurrentMap<String, CallableEntry> queue = new ConcurrentHashMap<String, CallableEntry>();
    private ThreadPoolExecutor executor;
    private Cache<Object> shortCache;

    public void initialize() throws InitializationException {
        int poolSize = this.notificationConfiguration.getRESTPoolSize();
        if (poolSize > 0) {
            this.executor = new CallableEntryExecutor(poolSize);
            try {
                this.shortCache = this.cacheManager.createNewCache((CacheConfiguration)new LRUCacheConfiguration("notification.rest.shortCache", 1000, 6000));
            }
            catch (CacheException e) {
                throw new InitializationException("Failed to create short cache", (Throwable)e);
            }
        }
    }

    public Object submit(String cacheKey, Callable<List> callable, boolean async, boolean count, boolean composite) throws Exception {
        Object cached = this.notificationCacheManager.getFromCache(cacheKey, count, composite);
        if (cached != null) {
            return cached;
        }
        if (this.executor != null) {
            if (async) {
                String asyncId = String.valueOf(this.counter.incrementAndGet());
                this.submit(cacheKey, callable, count, asyncId, composite);
                return asyncId;
            }
            Future<Object> future = this.executor.submit(new CallableEntry(cacheKey, callable, count, ((XWikiContext)this.xcontextProvider.get()).getUserReference(), composite));
            return future.get();
        }
        return callable.call();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submit(String longCacheKey, Callable<List> callable, boolean count, String asyncId, boolean composite) {
        ConcurrentMap<String, CallableEntry> concurrentMap = this.queue;
        synchronized (concurrentMap) {
            CallableEntry entry = (CallableEntry)this.queue.get(longCacheKey);
            if (entry == null) {
                entry = new CallableEntry(longCacheKey, callable, count, ((XWikiContext)this.xcontextProvider.get()).getUserReference(), asyncId, composite);
                this.queue.put(longCacheKey, entry);
                this.logger.debug("Added [{}] in the queue", (Object)entry);
                this.executor.submit(entry);
            } else {
                entry.addAsyncId(asyncId);
            }
        }
    }

    public Object popAsync(String asyncId) throws NotificationException {
        Object result = this.shortCache.get(asyncId);
        if (result != null) {
            this.shortCache.remove(asyncId);
        }
        if (result instanceof Throwable) {
            throw new NotificationException("Asynchronous notifications gathering failed", (Throwable)result);
        }
        return result;
    }

    public void dispose() throws ComponentLifecycleException {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
        if (this.shortCache != null) {
            this.shortCache.dispose();
        }
    }

    private class CallableEntryExecutor
    extends ThreadPoolExecutor
    implements ThreadFactory {
        private static final String THREAD_NAME = "Notification pool thread";
        private final ThreadFactory threadFactory;

        CallableEntryExecutor(int poolSize) {
            super(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            this.threadFactory = Executors.defaultThreadFactory();
            this.setThreadFactory(this);
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.threadFactory.newThread(r);
            thread.setDaemon(true);
            thread.setName(THREAD_NAME);
            thread.setPriority(5);
            return thread;
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            Thread.currentThread().setName(THREAD_NAME);
        }
    }

    private class CallableEntry
    implements Callable<Object> {
        private final String cacheKey;
        private final Callable<List> callable;
        private final Set<String> asyncIds = ConcurrentHashMap.newKeySet();
        private final boolean count;
        private final boolean composite;
        private final String initialAsyncId;
        private final DocumentReference currentUserReference;

        CallableEntry(String longCacheKey, Callable<List> callable, boolean count, DocumentReference currentUserReference, boolean composite) {
            this(longCacheKey, callable, count, currentUserReference, null, composite);
        }

        CallableEntry(String longCacheKey, Callable<List> callable, boolean count, DocumentReference currentUserReference, String asyncId, boolean composite) {
            this.cacheKey = longCacheKey;
            this.callable = callable;
            this.count = count;
            this.composite = composite;
            this.currentUserReference = currentUserReference;
            this.initialAsyncId = asyncId;
            if (asyncId != null) {
                this.addAsyncId(asyncId);
            }
        }

        public void addAsyncId(String asyncId) {
            this.asyncIds.add(asyncId);
        }

        @Override
        public Object call() throws Exception {
            Object object;
            NotificationEventExecutor.this.logger.debug("Starting execution [{}]", (Object)this);
            String threadName = Thread.currentThread().getName();
            Thread.currentThread().setName(this.toString());
            Object result = null;
            try {
                object = result = this.execute();
            }
            catch (Throwable e) {
                try {
                    result = e;
                    NotificationEventExecutor.this.logger.error("Failed to retrieve notifications for cache key [{}]", (Object)this.cacheKey, (Object)e);
                    throw e;
                }
                catch (Throwable throwable) {
                    NotificationEventExecutor.this.logger.debug("Finishing execution [{}]", (Object)this);
                    this.onFinish(result != null ? result : new NotificationException("No result"));
                    Thread.currentThread().setName(threadName);
                    throw throwable;
                }
            }
            NotificationEventExecutor.this.logger.debug("Finishing execution [{}]", (Object)this);
            this.onFinish(result != null ? result : new NotificationException("No result"));
            Thread.currentThread().setName(threadName);
            return object;
        }

        private Object execute() throws Exception {
            Object result = NotificationEventExecutor.this.notificationCacheManager.getFromCache(this.cacheKey, this.count, this.composite);
            if (result != null) {
                return result;
            }
            try {
                NotificationEventExecutor.this.contextManager.initialize(new ExecutionContext());
                ((XWikiContext)NotificationEventExecutor.this.xcontextProvider.get()).setUserReference(this.currentUserReference);
                List events = this.callable.call();
                NotificationEventExecutor.this.notificationCacheManager.setInCache(this.cacheKey, events, this.count, this.composite);
                result = this.count ? Integer.valueOf(events.size()) : events;
            }
            finally {
                NotificationEventExecutor.this.execution.removeContext();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onFinish(Object result) {
            ConcurrentMap<String, CallableEntry> concurrentMap = NotificationEventExecutor.this.queue;
            synchronized (concurrentMap) {
                if (NotificationEventExecutor.this.queue.remove(this.cacheKey, this)) {
                    NotificationEventExecutor.this.logger.debug("Removed [{}] from the queue", (Object)this);
                } else {
                    NotificationEventExecutor.this.logger.debug("Tried to remove [{}] from the queue but it could not be found", (Object)this);
                }
                this.asyncIds.stream().forEach(asyncId -> NotificationEventExecutor.this.shortCache.set(asyncId, result));
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(String.format("Notification event executor: %s : %s", this.count ? "count" : "list", this.cacheKey));
            if (this.initialAsyncId != null) {
                builder.append(" : ");
                builder.append(this.initialAsyncId);
            }
            return builder.toString();
        }
    }
}

