/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.preferences.internal.cache;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.XObjectPropertyUpdatedEvent;
import com.xpn.xwiki.internal.mandatory.XWikiUsersDocumentInitializer;
import com.xpn.xwiki.objects.BaseObjectReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.preferences.internal.cache.UnboundedEntityCacheManager;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="PreferenceCacheInvalidatorListener")
@Singleton
public class UnboundedEntityCacheInvalidatorListener
extends AbstractEventListener {
    public static final String NAME = "PreferenceCacheInvalidatorListener";
    @Inject
    private UnboundedEntityCacheManager caches;

    public UnboundedEntityCacheInvalidatorListener() {
        super(NAME, new Event[]{new WikiDeletedEvent(), new DocumentDeletedEvent(), new DocumentUpdatedEvent(), new XObjectPropertyUpdatedEvent(new EntityReference("active", EntityType.OBJECT_PROPERTY, (EntityReference)BaseObjectReference.any((String)XWikiUsersDocumentInitializer.CLASS_REFERENCE_STRING)))});
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof WikiDeletedEvent) {
            this.caches.remove(((WikiDeletedEvent)event).getWikiId());
        } else if (event instanceof DocumentDeletedEvent) {
            this.caches.remove(((XWikiDocument)source).getDocumentReference());
        } else {
            this.caches.update(((XWikiDocument)source).getDocumentReference());
        }
    }
}

