/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.preferences.internal;

import java.util.Arrays;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.preferences.NotificationPreference;
import org.xwiki.notifications.preferences.internal.AbstractDocumentNotificationPreferenceProvider;

@Component
@Singleton
@Named(value="wiki")
public class WikiNotificationPreferenceProvider
extends AbstractDocumentNotificationPreferenceProvider {
    public static final String NAME = "wiki";
    private static final LocalDocumentReference GLOBAL_PREFERENCES = new LocalDocumentReference(Arrays.asList("XWiki", "Notifications", "Code"), "NotificationAdministration");

    @Override
    public int getProviderPriority() {
        return 100;
    }

    @Override
    public List<NotificationPreference> getPreferencesForUser(DocumentReference user) throws NotificationException {
        return this.getPreferencesForWiki(user.getWikiReference());
    }

    @Override
    public List<NotificationPreference> getPreferencesForWiki(WikiReference wiki) throws NotificationException {
        return this.cachedNotificationPreferenceModelBridge.getNotificationsPreferences(wiki);
    }

    @Override
    protected void savePreferences(List<NotificationPreference> preferences, EntityReference target) throws NotificationException {
        if (target instanceof WikiReference) {
            this.cachedNotificationPreferenceModelBridge.saveNotificationsPreferences(new DocumentReference(GLOBAL_PREFERENCES, (WikiReference)target), preferences);
        } else {
            this.logger.warn("Preference's target [{}] is not a wiki reference. The corresponding preference will not be saved.");
        }
    }
}

