/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.preferences.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.preferences.NotificationPreference;
import org.xwiki.notifications.preferences.NotificationPreferenceManager;
import org.xwiki.notifications.preferences.NotificationPreferenceProvider;
import org.xwiki.notifications.preferences.internal.NotificationPreferenceModelBridge;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceSerializer;

@Component
@Singleton
public class DefaultNotificationPreferenceManager
implements NotificationPreferenceManager {
    @Inject
    @Named(value="cached")
    private NotificationPreferenceModelBridge cachedNotificationPreferenceModelBridge;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;
    @Inject
    @Named(value="document")
    private UserReferenceSerializer<DocumentReference> userReferenceSerializer;

    private List<NotificationPreferenceProvider> getProviders() throws NotificationException {
        try {
            List providers = this.componentManager.getInstanceList(NotificationPreferenceProvider.class);
            Collections.sort(providers, (o1, o2) -> o2.getProviderPriority() - o1.getProviderPriority());
            return providers;
        }
        catch (ComponentLookupException e) {
            throw new NotificationException("Unable to fetch the notifications preferences providers from the component manager", (Throwable)e);
        }
    }

    @Override
    public List<NotificationPreference> getAllPreferences(DocumentReference user) throws NotificationException {
        HashSet<NotificationPreference> notificationPreferences = new HashSet<NotificationPreference>();
        for (NotificationPreferenceProvider provider : this.getProviders()) {
            notificationPreferences.addAll(provider.getPreferencesForUser(user));
        }
        return new ArrayList<NotificationPreference>(notificationPreferences);
    }

    @Override
    public List<NotificationPreference> getAllPreferences(WikiReference wiki) throws NotificationException {
        HashSet<NotificationPreference> notificationPreferences = new HashSet<NotificationPreference>();
        for (NotificationPreferenceProvider provider : this.getProviders()) {
            notificationPreferences.addAll(provider.getPreferencesForWiki(wiki));
        }
        return new ArrayList<NotificationPreference>(notificationPreferences);
    }

    @Override
    public List<NotificationPreference> getPreferences(DocumentReference user, boolean isEnabled, NotificationFormat format) throws NotificationException {
        List<NotificationPreference> preferences = this.getAllPreferences(user);
        Iterator<NotificationPreference> it = preferences.iterator();
        while (it.hasNext()) {
            NotificationPreference preference = it.next();
            if (preference.isNotificationEnabled() == isEnabled && preference.getFormat().equals((Object)format)) continue;
            it.remove();
        }
        return preferences;
    }

    @Override
    public void setStartDateForUser(DocumentReference user, Date startDate) throws NotificationException {
        this.cachedNotificationPreferenceModelBridge.setStartDateForUser(user, startDate);
    }

    @Override
    public void savePreferences(List<NotificationPreference> preferences) throws NotificationException {
        HashMap preferencesMapping = new HashMap();
        for (NotificationPreference notificationPreference : preferences) {
            String providerHint = notificationPreference.getProviderHint();
            if (!this.componentManager.hasComponent(NotificationPreferenceProvider.class, providerHint)) continue;
            if (!preferencesMapping.containsKey(providerHint)) {
                preferencesMapping.put(providerHint, new ArrayList());
            }
            ((List)preferencesMapping.get(providerHint)).add(notificationPreference);
        }
        for (String providerHint : preferencesMapping.keySet()) {
            try {
                NotificationPreferenceProvider provider = (NotificationPreferenceProvider)this.componentManager.getInstance(NotificationPreferenceProvider.class, providerHint);
                provider.savePreferences((List)preferencesMapping.get(providerHint));
            }
            catch (ComponentLookupException e) {
                this.logger.error("Unable to retrieve the notification preference provide for hint {}: {}", (Object)providerHint, (Object)e);
            }
        }
    }

    @Override
    public String getNotificationGroupingStrategy(UserReference userReference, String target) throws NotificationException {
        return this.cachedNotificationPreferenceModelBridge.getEventGroupingStrategyHint((DocumentReference)this.userReferenceSerializer.serialize(userReference), target);
    }
}

