/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email.live;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.eventstream.Event;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.GroupingEventManager;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.internal.email.AbstractMimeMessageIterator;
import org.xwiki.notifications.notifiers.internal.email.live.LiveNotificationEmailEventFilter;
import org.xwiki.notifications.notifiers.internal.email.live.PrefilteringMimeMessageIterator;
import org.xwiki.notifications.preferences.NotificationEmailInterval;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultPrefilteringLiveMimeMessageIterator
extends AbstractMimeMessageIterator
implements PrefilteringMimeMessageIterator {
    @Inject
    private GroupingEventManager groupingEventManager;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> userReferenceResolver;
    @Inject
    private LiveNotificationEmailEventFilter eventFilter;
    private Map<DocumentReference, List<Event>> events;

    public void initialize(Map<DocumentReference, List<Event>> events, Map<String, Object> factoryParameters, EntityReference templateReference) {
        this.events = events;
        super.initialize(events.keySet().iterator(), factoryParameters, templateReference, NotificationEmailInterval.LIVE);
    }

    @Override
    protected List<CompositeEvent> retrieveCompositeEventList(DocumentReference user) throws NotificationException {
        List<Event> eventList = this.events.get(user);
        UserReference userReference = this.userReferenceResolver.resolve((Object)user, new Object[0]);
        List compositeEvents = this.groupingEventManager.getCompositeEvents(eventList, userReference, "email");
        ArrayList<CompositeEvent> result = new ArrayList<CompositeEvent>();
        for (CompositeEvent compositeEvent : compositeEvents) {
            if (!this.eventFilter.canAccessEvent(user, compositeEvent)) continue;
            result.add(compositeEvent);
        }
        return result;
    }
}

