/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email;

import com.xpn.xwiki.objects.BaseObject;
import java.lang.reflect.Type;
import java.util.Map;
import javax.inject.Inject;
import org.xwiki.component.annotation.Component;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.email.EmailTemplateRenderer;
import org.xwiki.notifications.notifiers.email.NotificationEmailRenderer;
import org.xwiki.notifications.notifiers.internal.AbstractWikiNotificationRenderer;
import org.xwiki.rendering.syntax.Syntax;
import org.xwiki.template.Template;

@Component(roles={WikiEmailNotificationRenderer.class})
public class WikiEmailNotificationRenderer
extends AbstractWikiNotificationRenderer
implements NotificationEmailRenderer {
    @Inject
    private EmailTemplateRenderer emailTemplateRenderer;
    private Template htmlTemplate;
    private Template plainTextTemplate;
    private Template emailSubjectTemplate;

    @Override
    public void initialize(BaseObject baseObject) throws NotificationException {
        super.initialize(baseObject);
        this.htmlTemplate = this.extractTemplate(baseObject, "htmlTemplate");
        this.plainTextTemplate = this.extractTemplate(baseObject, "plainTextTemplate");
        this.emailSubjectTemplate = this.extractTemplate(baseObject, "emailSubject");
    }

    public String renderHTML(CompositeEvent compositeEvent, String userId) throws NotificationException {
        if (this.htmlTemplate != null) {
            return this.emailTemplateRenderer.renderHTML(this.emailTemplateRenderer.executeTemplate(compositeEvent, userId, this.htmlTemplate, Syntax.XHTML_1_0, Map.of()));
        }
        return null;
    }

    public String renderPlainText(CompositeEvent compositeEvent, String userId) throws NotificationException {
        if (this.plainTextTemplate != null) {
            return this.emailTemplateRenderer.renderPlainText(this.emailTemplateRenderer.executeTemplate(compositeEvent, userId, this.plainTextTemplate, Syntax.PLAIN_1_0, Map.of()));
        }
        return null;
    }

    public String generateEmailSubject(CompositeEvent compositeEvent, String userId) throws NotificationException {
        if (this.emailSubjectTemplate != null) {
            return this.emailTemplateRenderer.renderPlainText(this.emailTemplateRenderer.executeTemplate(compositeEvent, userId, this.emailSubjectTemplate, Syntax.PLAIN_1_0, Map.of()));
        }
        return null;
    }

    public Type getRoleType() {
        return NotificationEmailRenderer.class;
    }
}

