/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.api.Attachment;
import com.xpn.xwiki.doc.XWikiAttachment;
import com.xpn.xwiki.doc.XWikiAttachmentContent;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.skin.InternalSkinManager;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.filter.input.InputSource;
import org.xwiki.filter.input.InputStreamInputSource;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.notifications.NotificationException;
import org.xwiki.skin.Resource;
import org.xwiki.text.StringUtils;

@Component(roles={LogoAttachmentExtractor.class})
@Singleton
public class LogoAttachmentExtractor {
    private static final String LOGO = "logo";
    private static final String SVG_EXTENSION = ".svg";
    @Inject
    private Provider<XWikiContext> xwikiContextProvider;
    @Inject
    @Named(value="all")
    private ConfigurationSource configurationSource;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private InternalSkinManager internalSkinManager;

    public Attachment getLogo() throws Exception {
        String skin;
        XWikiContext context = (XWikiContext)this.xwikiContextProvider.get();
        String colorTheme = (String)this.configurationSource.getProperty("colorTheme");
        if (StringUtils.isNotBlank((CharSequence)colorTheme)) {
            DocumentReference colorThemeRef = this.documentReferenceResolver.resolve((Object)colorTheme, new Object[0]);
            XWiki xwiki = context.getWiki();
            XWikiDocument doc = xwiki.getDocument(colorThemeRef, context);
            String logo = doc.getStringValue(LOGO);
            if (StringUtils.isBlank((CharSequence)logo)) {
                logo = doc.getStringValue("logoImage");
            }
            if (this.isLogoAttachementValid(doc, logo)) {
                XWikiAttachment attachment = doc.getAttachment(logo);
                return this.toLogoAttachment(attachment, context);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(skin = (String)this.configurationSource.getProperty("skin")))) {
            String logo;
            DocumentReference skinRef = this.documentReferenceResolver.resolve((Object)skin, new Object[0]);
            XWiki xwiki = context.getWiki();
            XWikiDocument doc = xwiki.getDocument(skinRef, context);
            if (this.isLogoAttachementValid(doc, logo = doc.getStringValue(LOGO))) {
                XWikiAttachment attachment = doc.getAttachment(logo);
                return this.toLogoAttachment(attachment, context);
            }
        }
        return this.newLogoAttachment("image/png", this.internalSkinManager.getCurrentSkin(true).getResource("logo.png"), context);
    }

    private Attachment toLogoAttachment(XWikiAttachment attachment, XWikiContext xcontext) throws XWikiException {
        attachment.loadAttachmentContent(xcontext);
        if (!attachment.getFilename().equals(LOGO)) {
            return this.newLogoAttachment(attachment.getMimeType(xcontext), (XWikiAttachmentContent)attachment.getAttachment_content().clone(), xcontext);
        }
        return new Attachment(attachment.getDoc().newDocument(xcontext), attachment, xcontext);
    }

    private Attachment newLogoAttachment(String mimeType, XWikiAttachmentContent content, XWikiContext xcontext) {
        XWikiAttachment attachment = new XWikiAttachment(null, LOGO);
        attachment.setAttachment_content(content);
        attachment.setMimeType(mimeType);
        return new Attachment(null, attachment, xcontext);
    }

    private Attachment newLogoAttachment(String mimeType, Resource sourceImageIS, XWikiContext xcontext) throws Exception {
        InputSource inputSource = sourceImageIS.getInputSource();
        if (inputSource instanceof InputStreamInputSource) {
            try (InputStreamInputSource inputStreamSource = (InputStreamInputSource)inputSource;){
                XWikiAttachmentContent content = new XWikiAttachmentContent();
                content.setContent(inputStreamSource.getInputStream());
                Attachment attachment = this.newLogoAttachment(mimeType, content, xcontext);
                return attachment;
            }
        }
        throw new NotificationException("Unsupported logo input source [" + String.valueOf(inputSource) + "]");
    }

    private boolean isLogoAttachementValid(XWikiDocument doc, String logo) {
        return StringUtils.isNotBlank((CharSequence)logo) && !logo.endsWith(SVG_EXTENSION) && doc.getAttachment(logo) != null;
    }
}

