/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.notifiers.internal.email.SortedEvent;

public class EventsSorter {
    private List<SortedEvent> sortedEvents = new ArrayList<SortedEvent>();

    public void add(CompositeEvent event, String html, String plainText) {
        this.sortedEvents.add(new SortedEvent(event, html, plainText));
    }

    public Map<String, List<SortedEvent>> sort() {
        Collections.sort(this.sortedEvents, this.getSortedEventComparator());
        this.groupEventsWithSameDocument();
        ArrayList<SortedEvent> topLevelEvents = new ArrayList<SortedEvent>();
        for (SortedEvent sortedEvent : this.sortedEvents) {
            SortedEvent nearestParent = this.findNearestParent(sortedEvent);
            if (nearestParent != null) {
                nearestParent.addChild(sortedEvent);
                continue;
            }
            topLevelEvents.add(sortedEvent);
        }
        this.sortedEvents = topLevelEvents;
        HashMap<String, List<SortedEvent>> sortedEventsByWikis = new HashMap<String, List<SortedEvent>>();
        for (SortedEvent sortedEvent : this.sortedEvents) {
            String wiki = this.getWiki(sortedEvent);
            List<SortedEvent> list = this.getList(sortedEventsByWikis, wiki);
            list.add(sortedEvent);
        }
        return sortedEventsByWikis;
    }

    private Comparator<SortedEvent> getSortedEventComparator() {
        return (e1, e2) -> {
            if (e1.getDocument() == null) {
                return e2.getDocument() == null ? 0 : 1;
            }
            if (e2.getDocument() == null) {
                return -1;
            }
            int documentSort = e1.getDocument().compareTo((EntityReference)e2.getDocument());
            if (documentSort == 0) {
                return e2.getDate().compareTo(e1.getDate());
            }
            return documentSort;
        };
    }

    private String getWiki(SortedEvent sortedEvent) {
        return sortedEvent.getEvent().getDocument() != null ? sortedEvent.getEvent().getDocument().getWikiReference().getName() : "";
    }

    private SortedEvent findNearestParent(SortedEvent sortedEvent) {
        if (sortedEvent.getEvent().getDocument() == null) {
            return null;
        }
        SortedEvent nearestParent = null;
        int nearestParentLevel = 0;
        for (SortedEvent possibleParent : this.sortedEvents) {
            if (possibleParent == sortedEvent || !possibleParent.isParent(sortedEvent) || possibleParent.getEvent().getDocument().size() <= nearestParentLevel) continue;
            nearestParent = possibleParent;
            nearestParentLevel = possibleParent.getEvent().getDocument().size();
        }
        return nearestParent;
    }

    private List<SortedEvent> getList(Map<String, List<SortedEvent>> sortedEventsByWikis, String wiki) {
        List<SortedEvent> list = sortedEventsByWikis.get(wiki);
        if (list == null) {
            list = new ArrayList<SortedEvent>();
            sortedEventsByWikis.put(wiki, list);
        }
        return list;
    }

    private void groupEventsWithSameDocument() {
        for (int i = 0; i < this.sortedEvents.size(); ++i) {
            SortedEvent event = this.sortedEvents.get(i);
            if (event.getDocument() == null) continue;
            int j = i + 1;
            while (j < this.sortedEvents.size()) {
                SortedEvent otherEvent = this.sortedEvents.get(j);
                if (event.getDocument().equals((Object)otherEvent.getDocument())) {
                    event.addEventWithTheSameDocument(otherEvent);
                    this.sortedEvents.remove(j);
                    continue;
                }
                ++j;
            }
        }
    }
}

