/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email.live;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.ApplicationReadyEvent;
import org.xwiki.bridge.event.WikiReadyEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.EntityEvent;
import org.xwiki.eventstream.events.MailEntityAddedEvent;
import org.xwiki.notifications.NotificationConfiguration;
import org.xwiki.notifications.notifiers.internal.email.live.PrefilteringLiveNotificationEmailManager;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.remote.RemoteObservationManagerContext;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
@Named(value="Prefiltering Live Notification Email Listener")
public class PrefilteringLiveNotificationEmailListener
extends AbstractEventListener {
    public static final String NAME = "Prefiltering Live Notification Email Listener";
    @Inject
    private NotificationConfiguration notificationConfiguration;
    @Inject
    private RemoteObservationManagerContext remoteState;
    @Inject
    private PrefilteringLiveNotificationEmailManager manager;
    @Inject
    private WikiDescriptorManager wikis;

    public PrefilteringLiveNotificationEmailListener() {
        super(NAME, new Event[]{new MailEntityAddedEvent(), new ApplicationReadyEvent(), new WikiReadyEvent()});
    }

    public void onEvent(Event event, Object source, Object data) {
        if (this.notificationConfiguration.isEnabled() && this.notificationConfiguration.areEmailsEnabled()) {
            if (event instanceof MailEntityAddedEvent) {
                if (!this.remoteState.isRemoteState()) {
                    this.manager.addEvent((EntityEvent)source);
                }
            } else if (event instanceof ApplicationReadyEvent) {
                this.manager.addEvents(this.wikis.getMainWikiId());
            } else if (event instanceof WikiReadyEvent) {
                this.manager.addEvents(((WikiReadyEvent)event).getWikiId());
            }
        }
    }
}

