/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email.live;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.concurrent.ExecutionContextRunnable;
import org.xwiki.eventstream.Event;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.notifications.NotificationConfiguration;
import org.xwiki.notifications.notifiers.internal.email.live.PrefilteringLiveNotificationEmailSender;

@Component(roles={PrefilteringLiveNotificationEmailDispatcher.class})
@Singleton
public class PrefilteringLiveNotificationEmailDispatcher
implements Initializable,
Disposable {
    @Inject
    private PrefilteringLiveNotificationEmailSender sender;
    @Inject
    private NotificationConfiguration notificationConfiguration;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    private ScheduledExecutorService processingService;
    private final BlockingQueue<QueueEntry> queue = new LinkedBlockingQueue<QueueEntry>();
    private long grace;

    public void initialize() throws InitializationException {
        this.grace = 60000L * (long)this.notificationConfiguration.liveNotificationsGraceTime();
        this.processingService = Executors.newSingleThreadScheduledExecutor();
    }

    public void dispose() throws ComponentLifecycleException {
        this.processingService.shutdownNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(Event event, DocumentReference userDocumentReference) {
        BlockingQueue<QueueEntry> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            for (QueueEntry entry : this.queue) {
                if (!entry.event.getId().equals(event.getId())) continue;
                entry.entities.add(userDocumentReference);
                return;
            }
        }
        QueueEntry entry = new QueueEntry(event, userDocumentReference);
        this.queue.add(entry);
        Instant instant = event.getDate().toInstant().plusMillis(this.grace);
        Duration duration = Duration.between(Instant.now(), instant);
        this.processingService.schedule((Runnable)new ExecutionContextRunnable(this::dispatch, this.componentManager), duration.getSeconds(), TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch() {
        QueueEntry currentEntry;
        BlockingQueue<QueueEntry> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            currentEntry = (QueueEntry)this.queue.remove();
        }
        if (currentEntry.entities.isEmpty()) {
            return;
        }
        HashMap<DocumentReference, List<Event>> eventsToSend = new HashMap<DocumentReference, List<Event>>();
        currentEntry.entities.forEach(entity -> eventsToSend.put((DocumentReference)entity, (List<Event>)new ArrayList<Event>(List.of(currentEntry.event))));
        this.queue.forEach(entry -> this.prepare((QueueEntry)entry, (Map<DocumentReference, List<Event>>)eventsToSend));
        if (!eventsToSend.isEmpty()) {
            this.sender.sendMails(eventsToSend);
        }
    }

    private void prepare(QueueEntry entry, Map<DocumentReference, List<Event>> eventsToSend) {
        entry.entities.forEach(entity -> {
            if (eventsToSend.containsKey(entity)) {
                List events = (List)eventsToSend.get(entity);
                events.add(entry.event);
                entry.entities.remove(entity);
            }
        });
    }

    private static class QueueEntry {
        private final Event event;
        private final Set<DocumentReference> entities = ConcurrentHashMap.newKeySet();

        QueueEntry(Event event, DocumentReference userReference) {
            this.event = event;
            this.entities.add(userReference);
        }
    }
}

