/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal.email;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.event.XObjectAddedEvent;
import com.xpn.xwiki.internal.event.XObjectDeletedEvent;
import com.xpn.xwiki.internal.event.XObjectUpdatedEvent;
import com.xpn.xwiki.internal.mandatory.XWikiUsersDocumentInitializer;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.notifiers.internal.email.IntervalUsersManager;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="IntervalUsersManagerInvalidator")
@Singleton
public class IntervalUsersManagerInvalidator
extends AbstractEventListener {
    public static final String NAME = "IntervalUsersManagerInvalidator";
    private static final EntityReference USER_OBJECT = BaseObjectReference.any((String)"XWiki.XWikiUsers");
    private static final EntityReference INTERVAL_OBJECT = BaseObjectReference.any((String)"XWiki.Notifications.Code.NotificationEmailPreferenceClass");
    private static final List<Event> EVENT_LIST = Arrays.asList(new XObjectAddedEvent(USER_OBJECT), new XObjectDeletedEvent(USER_OBJECT), new XObjectUpdatedEvent(USER_OBJECT), new XObjectAddedEvent(INTERVAL_OBJECT), new XObjectUpdatedEvent(INTERVAL_OBJECT), new XObjectDeletedEvent(INTERVAL_OBJECT), new WikiDeletedEvent());
    @Inject
    private IntervalUsersManager users;

    public IntervalUsersManagerInvalidator() {
        super(NAME, EVENT_LIST);
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof WikiDeletedEvent) {
            this.users.invalidateWiki(((WikiDeletedEvent)event).getWikiId());
        } else {
            XWikiDocument document = (XWikiDocument)source;
            if (this.isActive(document) || this.isActive(document.getOriginalDocument())) {
                this.users.invalidateUser(((XWikiDocument)source).getDocumentReference());
            }
        }
    }

    private boolean isActive(XWikiDocument document) {
        BaseObject userObject = document.getXObject((EntityReference)XWikiUsersDocumentInitializer.XWIKI_USERS_DOCUMENT_REFERENCE);
        return userObject != null && userObject.getIntValue("active", 0) == 1;
    }
}

