/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.script.ScriptContext;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.NotificationDisplayer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateManager;

@Component
@Singleton
public class DefaultNotificationDisplayer
implements NotificationDisplayer {
    private static final String EVENT_BINDING_NAME = "event";
    @Inject
    private TemplateManager templateManager;
    @Inject
    private ScriptContextManager scriptContextManager;

    @Override
    public Block renderNotification(CompositeEvent eventNotification) throws NotificationException {
        ScriptContext scriptContext = this.scriptContextManager.getScriptContext();
        try {
            scriptContext.setAttribute(EVENT_BINDING_NAME, eventNotification, 100);
            Template template = this.getSpecificTemplate(eventNotification);
            XDOM xDOM = template != null ? this.templateManager.execute(template) : this.templateManager.execute("notification/default.vm");
            return xDOM;
        }
        catch (Exception e) {
            throw new NotificationException(String.format("Failed to render the notification for events [%s]", StringUtils.join((Iterable)eventNotification.getEventIds(), (char)',')), (Throwable)e);
        }
        finally {
            scriptContext.removeAttribute(EVENT_BINDING_NAME, 100);
        }
    }

    private Template getSpecificTemplate(CompositeEvent eventNotification) {
        String templateName = String.format("notification/%s.vm", eventNotification.getType().replaceAll("\\/", "."));
        return this.templateManager.getTemplate(templateName);
    }

    @Override
    public List<String> getSupportedEvents() {
        return Collections.emptyList();
    }
}

