/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.NotificationConfiguration;
import org.xwiki.notifications.sources.NotificationParameters;

@Component(roles={DefaultNotificationCacheManager.class})
@Singleton
public class DefaultNotificationCacheManager
implements Initializable,
Disposable {
    private static final String CACHE_KEY_SEPARATOR = "/";
    @Inject
    private NotificationConfiguration configuration;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    private Cache<List<Object>> longEventCache;
    private Cache<List<Object>> longCompositeEventCache;
    private Cache<Integer> longIndividualEventCountCache;
    private Cache<Integer> longCompositeEventCountCache;

    public void initialize() throws InitializationException {
        if (this.configuration.isRestCacheEnabled()) {
            try {
                this.longEventCache = this.cacheManager.createNewCache((CacheConfiguration)new LRUCacheConfiguration("notification.rest.longCache.events", 100, 86400));
                this.longIndividualEventCountCache = this.cacheManager.createNewCache((CacheConfiguration)new LRUCacheConfiguration("notification.rest.longCache.count", 10000, 86400));
                this.longCompositeEventCache = this.cacheManager.createNewCache((CacheConfiguration)new LRUCacheConfiguration("notification.rest.longCache.events.composite", 100, 86400));
                this.longCompositeEventCountCache = this.cacheManager.createNewCache((CacheConfiguration)new LRUCacheConfiguration("notification.rest.longCache.count.composite", 10000, 86400));
            }
            catch (CacheException e) {
                throw new InitializationException("Failed to create one of the notification cache.", (Throwable)e);
            }
        }
    }

    private void addCacheKeyElement(StringBuilder cacheKeyBuilder, String value) {
        if (value != null) {
            cacheKeyBuilder.append(value.length());
            cacheKeyBuilder.append(value);
        }
    }

    public String createCacheKey(NotificationParameters notificationParameters) {
        StringBuilder cacheKeyBuilder = new StringBuilder();
        this.addCacheKeyElement(cacheKeyBuilder, notificationParameters.format.name());
        cacheKeyBuilder.append(CACHE_KEY_SEPARATOR);
        this.addCacheKeyElement(cacheKeyBuilder, (String)this.entityReferenceSerializer.serialize((EntityReference)notificationParameters.user, new Object[0]));
        cacheKeyBuilder.append(CACHE_KEY_SEPARATOR);
        if (notificationParameters.endDate != null) {
            cacheKeyBuilder.append(notificationParameters.endDate.getTime()).append(CACHE_KEY_SEPARATOR);
            cacheKeyBuilder.append(notificationParameters.endDateIncluded).append(CACHE_KEY_SEPARATOR);
        }
        cacheKeyBuilder.append(notificationParameters.expectedCount).append(CACHE_KEY_SEPARATOR).append(notificationParameters.onlyUnread).append(CACHE_KEY_SEPARATOR).append(notificationParameters.hashCode());
        return cacheKeyBuilder.toString();
    }

    public Object getFromCache(String cacheKey, boolean count, boolean composite) {
        Object result = null;
        if (this.configuration.isRestCacheEnabled()) {
            result = count && composite ? this.longCompositeEventCountCache.get(cacheKey) : (count && !composite ? this.longIndividualEventCountCache.get(cacheKey) : (!count && composite ? this.longCompositeEventCache.get(cacheKey) : this.longEventCache.get(cacheKey)));
        }
        return result;
    }

    public void setInCache(String cacheKey, List<Object> events, boolean count, boolean composite) {
        if (this.configuration.isRestCacheEnabled()) {
            if (count && composite) {
                this.longCompositeEventCountCache.set(cacheKey, (Object)events.size());
            } else if (count && !composite) {
                this.longIndividualEventCountCache.set(cacheKey, (Object)events.size());
            } else if (!count && composite) {
                this.longCompositeEventCache.set(cacheKey, events);
            } else {
                this.longEventCache.set(cacheKey, events);
            }
        }
    }

    public void flushLongCache() {
        if (this.configuration.isRestCacheEnabled()) {
            this.longEventCache.removeAll();
            this.longIndividualEventCountCache.removeAll();
            this.longCompositeEventCache.removeAll();
            this.longCompositeEventCountCache.removeAll();
        }
    }

    public void dispose() {
        if (this.configuration.isRestCacheEnabled()) {
            this.longIndividualEventCountCache.dispose();
            this.longEventCache.dispose();
            this.longCompositeEventCache.dispose();
            this.longCompositeEventCountCache.dispose();
        }
    }
}

