/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.notifiers.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.job.GroupedJobInitializer;
import org.xwiki.job.JobGroupPath;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.CompositeEventStatusManager;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.internal.DefaultNotificationCacheManager;
import org.xwiki.notifications.notifiers.internal.InternalHtmlNotificationRenderer;
import org.xwiki.notifications.notifiers.internal.NotificationAsyncRendererConfiguration;
import org.xwiki.notifications.sources.NotificationParameters;
import org.xwiki.notifications.sources.ParametrizedNotificationManager;
import org.xwiki.rendering.RenderingException;
import org.xwiki.rendering.async.internal.AsyncRenderer;
import org.xwiki.rendering.async.internal.AsyncRendererResult;

@Component(roles={DefaultAsyncNotificationRenderer.class})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultAsyncNotificationRenderer
implements AsyncRenderer {
    private NotificationAsyncRendererConfiguration configuration;
    @Inject
    private DefaultNotificationCacheManager notificationCacheManager;
    @Inject
    private InternalHtmlNotificationRenderer htmlNotificationRenderer;
    @Inject
    private CompositeEventStatusManager compositeEventStatusManager;
    @Inject
    private ParametrizedNotificationManager notificationManager;
    @Inject
    private EntityReferenceSerializer<String> documentReferenceSerializer;
    @Inject
    @Named(value="AsyncNotificationRenderer")
    private GroupedJobInitializer jobInitializer;
    private String cacheKey;

    public void initialize(NotificationAsyncRendererConfiguration configuration) {
        this.configuration = configuration;
        this.cacheKey = this.notificationCacheManager.createCacheKey(configuration.getNotificationParameters());
    }

    public List<String> getId() {
        String queryType = this.configuration.isCount() ? "count" : "display";
        return Arrays.asList("notifications", queryType, this.cacheKey.replaceAll("/", "_"));
    }

    public AsyncRendererResult render(boolean async, boolean cached) throws RenderingException {
        String stringResult;
        Object fromCache = this.notificationCacheManager.getFromCache(this.cacheKey, this.configuration.isCount(), true);
        NotificationParameters notificationParameters = this.configuration.getNotificationParameters();
        List events = null;
        Integer count = null;
        if (fromCache == null) {
            try {
                events = this.notificationManager.getEvents(notificationParameters);
                count = events.size();
                this.notificationCacheManager.setInCache(this.cacheKey, new ArrayList<Object>(events), this.configuration.isCount(), true);
            }
            catch (NotificationException e) {
                throw new RenderingException("Error while retrieving the notification", (Throwable)e);
            }
        } else if (this.configuration.isCount()) {
            count = (Integer)fromCache;
        } else {
            events = (List)fromCache;
        }
        if (this.configuration.isCount()) {
            stringResult = this.htmlNotificationRenderer.render(count);
        } else {
            try {
                boolean loadMore = events.size() == notificationParameters.expectedCount;
                List compositeEventStatuses = null;
                String userId = null;
                if (notificationParameters.user != null) {
                    userId = (String)this.documentReferenceSerializer.serialize((EntityReference)notificationParameters.user, new Object[0]);
                }
                if (userId != null) {
                    compositeEventStatuses = this.compositeEventStatusManager.getCompositeEventStatuses(events, userId);
                }
                stringResult = this.htmlNotificationRenderer.render(events, compositeEventStatuses, loadMore);
            }
            catch (Exception e) {
                throw new RenderingException("Error while retrieving the event status", (Throwable)e);
            }
        }
        return new AsyncRendererResult(stringResult);
    }

    public boolean isAsyncAllowed() {
        return true;
    }

    public boolean isCacheAllowed() {
        return false;
    }

    public JobGroupPath getJobGroupPath() {
        return this.jobInitializer.getId();
    }
}

