/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.watch;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterPreferenceManager;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.internal.DefaultNotificationFilterPreference;
import org.xwiki.notifications.filters.internal.scope.ScopeNotificationFilterLocationStateComputer;
import org.xwiki.notifications.filters.internal.scope.ScopeNotificationFilterPreference;
import org.xwiki.notifications.filters.internal.scope.WatchedLocationState;
import org.xwiki.notifications.filters.watch.WatchedEntityReference;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceSerializer;

public class WatchedLocationReference
implements WatchedEntityReference {
    private static final Set<NotificationFormat> ALL_NOTIFICATION_FORMATS = Set.of(NotificationFormat.values());
    private final ComponentManager componentManager;
    private final EntityReference entityReference;
    private final String serializedReference;
    private final EntityReferenceResolver<String> resolver;
    private final ScopeNotificationFilterLocationStateComputer stateComputer;
    private final NotificationFilterPreferenceManager notificationFilterPreferenceManager;
    private final UserReferenceSerializer<DocumentReference> userReferenceSerializer;

    public WatchedLocationReference(EntityReference entityReference, ComponentManager componentManager) throws ComponentLookupException {
        this.entityReference = entityReference;
        this.componentManager = componentManager;
        this.resolver = (EntityReferenceResolver)componentManager.getInstance((Type)new DefaultParameterizedType(null, EntityReferenceResolver.class, new Type[]{String.class}));
        EntityReferenceSerializer serializer = (EntityReferenceSerializer)componentManager.getInstance((Type)new DefaultParameterizedType(null, EntityReferenceSerializer.class, new Type[]{String.class}));
        this.stateComputer = (ScopeNotificationFilterLocationStateComputer)componentManager.getInstance(ScopeNotificationFilterLocationStateComputer.class);
        this.notificationFilterPreferenceManager = (NotificationFilterPreferenceManager)componentManager.getInstance(NotificationFilterPreferenceManager.class);
        this.userReferenceSerializer = (UserReferenceSerializer)componentManager.getInstance((Type)new DefaultParameterizedType(null, UserReferenceSerializer.class, new Type[]{DocumentReference.class}), "document");
        this.serializedReference = (String)serializer.serialize(entityReference, new Object[0]);
    }

    @Override
    public boolean isWatched(DocumentReference userReference) throws NotificationException {
        WatchedLocationState locationWatched = this.stateComputer.isLocationWatched(this.notificationFilterPreferenceManager.getFilterPreferences(userReference), this.entityReference, null, null, false, true, false);
        return locationWatched.getState() == WatchedLocationState.WatchedState.WATCHED || locationWatched.getState() == WatchedLocationState.WatchedState.WATCHED_BY_ANCESTOR || locationWatched.getState() == WatchedLocationState.WatchedState.WATCHED_WITH_CHILDREN;
    }

    @Override
    public boolean isWatchedWithAllEventTypes(DocumentReference userReference) throws NotificationException {
        return this.getWatchedStatus(userReference) == WatchedEntityReference.WatchedStatus.WATCHED_FOR_ALL_EVENTS_AND_FORMATS;
    }

    @Override
    public WatchedEntityReference.WatchedStatus getWatchedStatus(UserReference userReference) throws NotificationException {
        DocumentReference userDocReference = (DocumentReference)this.userReferenceSerializer.serialize(userReference);
        return this.getWatchedStatus(userDocReference);
    }

    public WatchedEntityReference.WatchedStatus getWatchedStatus(DocumentReference userReference) throws NotificationException {
        Collection filterPreferences = this.notificationFilterPreferenceManager.getFilterPreferences(userReference);
        WatchedLocationState locationWatched = this.stateComputer.isLocationWatchedWithAllTypesAndFormats(filterPreferences, this.entityReference);
        return switch (locationWatched.getState()) {
            case WatchedLocationState.WatchedState.CUSTOM -> WatchedEntityReference.WatchedStatus.CUSTOM;
            case WatchedLocationState.WatchedState.WATCHED -> WatchedEntityReference.WatchedStatus.WATCHED_FOR_ALL_EVENTS_AND_FORMATS;
            case WatchedLocationState.WatchedState.WATCHED_BY_ANCESTOR -> WatchedEntityReference.WatchedStatus.WATCHED_BY_ANCESTOR_FOR_ALL_EVENTS_AND_FORMATS;
            case WatchedLocationState.WatchedState.WATCHED_WITH_CHILDREN -> WatchedEntityReference.WatchedStatus.WATCHED_WITH_CHILDREN_FOR_ALL_EVENTS_AND_FORMATS;
            case WatchedLocationState.WatchedState.BLOCKED -> WatchedEntityReference.WatchedStatus.BLOCKED_FOR_ALL_EVENTS_AND_FORMATS;
            case WatchedLocationState.WatchedState.BLOCKED_BY_ANCESTOR -> WatchedEntityReference.WatchedStatus.BLOCKED_BY_ANCESTOR_FOR_ALL_EVENTS_AND_FORMATS;
            case WatchedLocationState.WatchedState.BLOCKED_WITH_CHILDREN -> WatchedEntityReference.WatchedStatus.BLOCKED_WITH_CHILDREN_FOR_ALL_EVENTS_AND_FORMATS;
            default -> WatchedEntityReference.WatchedStatus.NOT_SET;
        };
    }

    @Override
    public Optional<Pair<EntityReference, WatchedEntityReference.WatchedStatus>> getFirstFilteredAncestor(UserReference userReference) throws NotificationException {
        Optional<Pair<EntityReference, WatchedEntityReference.WatchedStatus>> result = Optional.empty();
        WatchedEntityReference.WatchedStatus watchedStatus = this.getWatchedStatus(userReference);
        if (watchedStatus.isBlocked() || watchedStatus.isWatched()) {
            EntityReference parent;
            EntityReference currentReference = this.entityReference;
            WatchedEntityReference.WatchedStatus parentWatchedStatus = null;
            do {
                if ((parent = currentReference.getParent()) == null) continue;
                WatchedLocationReference parentWatchedLocationReference = null;
                try {
                    parentWatchedLocationReference = new WatchedLocationReference(parent, this.componentManager);
                }
                catch (ComponentLookupException e) {
                    throw new NotificationException("Error when creating a new reference", (Throwable)e);
                }
                parentWatchedStatus = parentWatchedLocationReference.getWatchedStatus(userReference);
            } while ((currentReference = parent) != null && !this.keepAncestor(parentWatchedStatus));
            if (currentReference != null) {
                result = Optional.of(Pair.of((Object)currentReference, parentWatchedStatus));
            }
        }
        return result;
    }

    private boolean keepAncestor(WatchedEntityReference.WatchedStatus ancestorWatchedStatus) {
        return (ancestorWatchedStatus.isWatched() || ancestorWatchedStatus.isBlocked()) && ancestorWatchedStatus != WatchedEntityReference.WatchedStatus.WATCHED_BY_ANCESTOR_FOR_ALL_EVENTS_AND_FORMATS && ancestorWatchedStatus != WatchedEntityReference.WatchedStatus.BLOCKED_BY_ANCESTOR_FOR_ALL_EVENTS_AND_FORMATS;
    }

    @Override
    public boolean matchExactly(NotificationFilterPreference notificationFilterPreference) {
        if ("scopeNotificationFilter".equals(notificationFilterPreference.getFilterName()) && notificationFilterPreference.getEventTypes().isEmpty() && notificationFilterPreference.getNotificationFormats().containsAll(Set.of(NotificationFormat.values()))) {
            ScopeNotificationFilterPreference scope = new ScopeNotificationFilterPreference(notificationFilterPreference, this.resolver);
            return this.entityReference.equals((Object)scope.getScopeReference());
        }
        return false;
    }

    @Override
    public boolean match(NotificationFilterPreference notificationFilterPreference) {
        if ("scopeNotificationFilter".equals(notificationFilterPreference.getFilterName())) {
            ScopeNotificationFilterPreference scope = new ScopeNotificationFilterPreference(notificationFilterPreference, this.resolver);
            return this.entityReference.equals((Object)scope.getScopeReference());
        }
        return false;
    }

    @Override
    public NotificationFilterPreference createInclusiveFilterPreference() {
        return new ScopeNotificationFilterPreference((NotificationFilterPreference)this.createFilterPreference(), this.resolver);
    }

    @Override
    public NotificationFilterPreference createExclusiveFilterPreference() {
        DefaultNotificationFilterPreference preference = this.createFilterPreference();
        preference.setFilterType(NotificationFilterType.EXCLUSIVE);
        return new ScopeNotificationFilterPreference((NotificationFilterPreference)preference, this.resolver);
    }

    private DefaultNotificationFilterPreference createFilterPreference() {
        DefaultNotificationFilterPreference filterPreference = new DefaultNotificationFilterPreference();
        filterPreference.setEnabled(true);
        filterPreference.setFilterType(NotificationFilterType.INCLUSIVE);
        filterPreference.setFilterName("scopeNotificationFilter");
        filterPreference.setNotificationFormats(ALL_NOTIFICATION_FORMATS);
        filterPreference.setStartingDate(new Date());
        switch (this.entityReference.getType()) {
            case WIKI: {
                filterPreference.setWiki(this.serializedReference);
                break;
            }
            case SPACE: {
                filterPreference.setPage(this.serializedReference);
                break;
            }
            case DOCUMENT: {
                filterPreference.setPageOnly(this.serializedReference);
                break;
            }
        }
        return filterPreference;
    }

    public String toString() {
        return this.serializedReference;
    }
}

