/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.watch;

import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.stability.Unstable;
import org.xwiki.user.UserReference;

public interface WatchedEntityReference {
    @Unstable
    default public WatchedStatus getWatchedStatus(UserReference userReference) throws NotificationException {
        return WatchedStatus.CUSTOM;
    }

    @Unstable
    default public Optional<Pair<EntityReference, WatchedStatus>> getFirstFilteredAncestor(UserReference userReference) throws NotificationException {
        return Optional.empty();
    }

    @Deprecated(since="16.5.0RC1")
    public boolean isWatched(DocumentReference var1) throws NotificationException;

    @Deprecated(since="16.5.0RC1")
    default public boolean isWatchedWithAllEventTypes(DocumentReference userReference) throws NotificationException {
        return this.isWatched(userReference);
    }

    public boolean matchExactly(NotificationFilterPreference var1);

    default public boolean match(NotificationFilterPreference notificationFilterPreference) {
        return this.matchExactly(notificationFilterPreference);
    }

    public NotificationFilterPreference createInclusiveFilterPreference();

    public NotificationFilterPreference createExclusiveFilterPreference();

    public static enum WatchedStatus {
        WATCHED_FOR_ALL_EVENTS_AND_FORMATS(true, false),
        WATCHED_BY_ANCESTOR_FOR_ALL_EVENTS_AND_FORMATS(true, false),
        WATCHED_WITH_CHILDREN_FOR_ALL_EVENTS_AND_FORMATS(true, false),
        NOT_SET(false, false),
        BLOCKED_FOR_ALL_EVENTS_AND_FORMATS(false, true),
        BLOCKED_BY_ANCESTOR_FOR_ALL_EVENTS_AND_FORMATS(false, true),
        BLOCKED_WITH_CHILDREN_FOR_ALL_EVENTS_AND_FORMATS(false, true),
        CUSTOM(false, false);

        private final boolean blocked;
        private final boolean watched;

        @Unstable
        private WatchedStatus(boolean watched, boolean blocked) {
            this.blocked = blocked;
            this.watched = watched;
        }

        @Unstable
        public boolean isWatched() {
            return this.watched;
        }

        @Unstable
        public boolean isBlocked() {
            return this.blocked;
        }
    }
}

