/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.migration;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.notifications.filters.internal.DefaultNotificationFilterPreference;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="R160500000XWIKI22271")
@Singleton
public class R160500000XWIKI22271DataMigration
extends AbstractHibernateDataMigration {
    private static final String SEARCH_FILTERS_STATEMENT = "select nfp from DefaultNotificationFilterPreference nfp where nfp.id not in (select nfp2.id from DefaultNotificationFilterPreference nfp2 where nfp2.page like :wikiPrefix or nfp2.pageOnly like :wikiPrefix or nfp2.user like :wikiPrefix or nfp2.wiki = :wikiId)";
    private static final String DELETE_FILTER_STATEMENT = "delete from DefaultNotificationFilterPreference where internalId in (:filterIds)";
    private static final int BATCH_SIZE = 100;
    @Inject
    private QueryManager queryManager;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Logger logger;

    public String getDescription() {
        return "Ensure that filters related to deleted wiki are clean up.";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(160500000);
    }

    public boolean shouldExecute(XWikiDBVersion startupVersion) {
        boolean shouldExecute;
        boolean bl = shouldExecute = super.shouldExecute(startupVersion) && this.wikiDescriptorManager.isMainWiki(this.wikiDescriptorManager.getCurrentWikiId());
        if (shouldExecute) {
            int version = startupVersion.getVersion();
            shouldExecute = version < 160401000 || version >= 160500000;
        }
        return shouldExecute;
    }

    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
        String currentWikiId = this.getXWikiContext().getWikiId();
        HashSet idsToCleanup = new HashSet();
        int offset = 0;
        List results = null;
        try {
            Collection allIds = this.wikiDescriptorManager.getAllIds();
            do {
                if (!(results = this.queryManager.createQuery(SEARCH_FILTERS_STATEMENT, "hql").bindValue("wikiPrefix", (Object)(currentWikiId.replaceAll("([%_!])", "!$1") + ":%")).bindValue("wikiId", (Object)currentWikiId).setOffset(offset).setLimit(100).execute()).isEmpty()) {
                    this.logger.info("Performing analysis of [{}] filters to find those related to removed wikis", (Object)results.size());
                    results.forEach(filter -> {
                        if (!this.isFilterAboutExistingWiki((DefaultNotificationFilterPreference)filter, allIds)) {
                            idsToCleanup.add(filter.getInternalId());
                        }
                    });
                }
                offset += results.size();
            } while (!results.isEmpty());
        }
        catch (QueryException e) {
            throw new DataMigrationException("Error while performing query for finding filters", (Throwable)e);
        }
        catch (WikiManagerException e) {
            throw new DataMigrationException("Error when searching for wiki ids", (Throwable)e);
        }
        if (!idsToCleanup.isEmpty()) {
            this.logger.info("Removing [{}] filters related to deleted wikis", (Object)idsToCleanup.size());
            try {
                this.getStore().executeWrite(this.getXWikiContext(), session -> {
                    session.createQuery(DELETE_FILTER_STATEMENT).setParameter("filterIds", (Object)idsToCleanup).executeUpdate();
                    return null;
                });
            }
            catch (XWikiException e) {
                throw new DataMigrationException("Error when performing the request to clean up filters.", (Throwable)e);
            }
        } else {
            this.logger.info("No filter has been found related to deleted wikis.");
        }
    }

    private boolean isFilterAboutExistingWiki(DefaultNotificationFilterPreference filterPreference, Collection<String> wikiIds) {
        if (filterPreference.getWikiId().isPresent()) {
            return wikiIds.contains(filterPreference.getWikiId().get());
        }
        return false;
    }
}

